## Matrix (MDX++)

icCube MDX support for matrix objects allows to perform fundamental operations of numerical linear algebra.
Several ways of constructing matrices are available via the MDX functions:

* [Matrix()](../mdx/Matrix.md)
* [MatrixN()](../mdx/MatrixN.md)
* [MatrixA()](../mdx/MatrixA.md)

### Operators

The MDX operators have been extended to support basic arithmetic operations (i.e., addition, multiplication,
division, power) and comparison (i.e., equality, comparison). Some basic examples :

    MatrixN( VectorN(2,3),VectorN(2,3) ) + 2 = MatrixN( VectorN(4,5),VectorN(4,5) )
    MatrixN( VectorN(2,3),VectorN(2,3) ) - 2 = MatrixN( VectorN(0,1),VectorN(0,1) )
    MatrixN( VectorN(2,3),VectorN(2,3) ) * 2 = MatrixN( VectorN(4,6),VectorN(4,6) )
    MatrixN( VectorN(2,3),VectorN(2,3) ) / 2 = MatrixN( VectorN(1,2/3),VectorN(1,2/3) )
    MatrixN( VectorN(11,12),VectorN(21,22) ) * VectorN(1,2) = VectorN( 11 * 1 + 21 * 2, 12*1 + 22 * 2) 

### Object Oriented Methods

The notation `matrix->method( ... )` allows for accessing the methods of the matrix. The conversion of the parameters
(as well as the result) is handled automatically by the MDX engine. As an example, the following code return the number
of elements in the matrix:

    Matrix( 

        { [Time].[Calendar].[2010], [Time].[Calendar].[2011] },
        { [Geography].[Geo].[Switzerland],[Geography].[Geo].[France] },
        [Measures].[Amount]

    )->length()

#### inverse()

Returns the variance of the values in the matrix: `sum((x_i - mean)^2) / (n - 1)`.

#### max()

Returns the maximum of the elements of the matrix.

#### mean()

Returns the arithmetic mean of the elements of the matrix.

#### min()

Returns the minimum of the elements of the matrix.

#### round(int precision)

Returns a new matrix with all values rounded to the specified number of decimal places (values are rounded using
the `ROUND_HALF_UP` method).

#### sum()

Returns the sum of the elements of the matrix.

#### value(col,row)

Returns the value of the `{col,row}` element of the matrix. Note the order is the inverse as the one defined
by standard matrix algebra.

_
