## Date & Datetime (MDX++)

icCube MDX supports both date & datetime. The datetime being a date with time information (hours, minutes).
Different functions allow to perform operations on dates they can be found in the MDX function documentation:

* [Excel Date Functions](../mdx/Excel%20Date%20Functions.md)
* [Excel Conversion Functions](../mdx/Excel%20Conversion%20Functions.md)
* [Java Functions](../mdx/Java%20Functions.md)

If you are looking to manipulate a `Date/Time` hierarchy check the MDX date specific navigation functions:

* [MDX Functions Reference](../mdx/functions.md)

### Operators

Some basic operations can be performed on dates and datetimes values :

    -- adds two days to the date or datetime
    Now() + 2 = Now()->plusDays(2)
                                       
    -- calculates the difference in days between two dates or datetimes in days
    Now() - Now()->plusDays(2) = -2 
                                       
    -- one hour difference calculated in days units
    Now() - Now()->plusHours(-1) = 1/24
                           
    -- datetime is stripped from time information before comparing to a date, in our example same date
    Now() > Today() = false

### Object Oriented Methods

The notation `scalar->method( ... )` allows for accessing the methods of the date and datetime scalar object:

#### dayOfWeek()

Returns the day of the week (integer).

#### dayOfMonth()

Returns the day of the month (integer).

#### dayOfYear()

Returns the day of the year (integer).

#### hourOfDay()

Returns the hour of the day (integer).

#### plusYears(int years)

Returns the date or datetime adding the number of years.

#### plusMonths(int months)

Returns the date or datetime adding the number of months.

#### plusDays(int days)

Returns the date or datetime adding the number of days.

#### plusHours(int hours)

Returns the datetime adding the number of hours (only available for datetime objects)

#### plusMinutes(int minutes)

Returns the datetime adding the number of minutes (only available for datetime objects)

#### plusSeconds(int seconds)

Returns the datetime adding the number of seconds (only available for datetime objects)

#### plusMillis(int millis)

Returns the datetime adding the number of milliseconds (only available for datetime objects)

#### minusYears(int years)

Returns the date or datetime subtracting the number of years.

#### minusMonths(int months)

Returns the date or datetime subtracting the number of months.

#### minusDays(int days)

Returns the date or datetime subtracting the number of days.

#### minusHours(int hours)

Returns the datetime subtracting the number of hours (only available for datetime objects).

#### minusMinutes(int minutes)

Returns the datetime subtracting the number of minutes (only available for datetime objects).

#### minusSeconds(int seconds)

Returns the datetime subtracting the number of seconds (only available for datetime objects).

#### minusMillis(int millis)

Returns the datetime subtracting the number of milliseconds (only available for datetime objects).

#### withDayOfMonth(int dayOfMonth)

Update the day of month field.

#### with DayOfWeek(int dayOfWeek)

Update the day of week field.

#### withDayOfYear(int dayOfYear)

Update the day of year field.

#### withHourOfDay(int hourOfDay)

Update the hour of day field (only available for datetime objects).

#### withMinuteOfHour(int minuteOfHour)

Update the minute of hour field (only available for datetime objects).

#### withSecondOfMinute(int secondOfMinute)

Update the second of minute field (only available for datetime objects).

#### withMillisOfSecond(int millisOfSecond)

Update the millis of second field (only available for datetime objects).

#### toDate()

Returns the date part of a datetime object (only available for datetime objects).

#### toDateTime(int hours, int minutes)

Returns the datetime of a date object (only available for date objects).

_