## WHERE Clause (aka. Slicer)

The `SELECT` expression can also specify a `WHERE` clause in order to reduce the scope of a query. When a `WHERE`
clause is not specified in a query, the entire cube space is taken into account when calculating results. When we do
specify a `WHERE` clause the scope of the query is reduced. For example:

    SELECT
        [Measures].Members ON 0,
        [Geography].[Geo].Members ON 1
    FROM
        [Sales]
    WHERE
        [Time].[Calendar].[Year].[2010]

In the query above, only that section of the cube where the year is `2010` is taken into account as the scope
of the query. The rest of the cube is ignored. This is why the `WHERE` clause is called the `slicer`: because
it takes a `slice` from the entire cube and performs calculations only on that slice of data.

To get more details about the slicer, several illustrated working examples are available from our MDX documentation
pages [here](../mdx/Where%20Clause.md).

## Next Step

[FROM as a slicer](from_slicer.md).

_
