## Named Sets

Similar to calculated members, a named set is an MDX expression defining the content of a set that can then be used
wherever a set is expected. Named sets can be defined within the scope of a `SELECT` expression. Note that they're
evaluated in the context of the slicer, if available:

    WITH
        SET [European Countries] AS [Geography].[Geo].[Europe].Children
    SELECT
        [Measures].[Amount] ON COLUMNS,
        [European Countries] ON ROWS
    FROM
        [Sales]

The example above is selecting the amount of sales for each European country.

The named sets also have scope. When the set is defined in the query by using the `SET` clause, as shown above,
the scope of the set is only limited to the lifetime of the query. When the query executes again, the set is
re-calculated. When the `SET` is defined in the cube itself, it can be of either session or of global scope.

## Next Step

We have now reached the end of our gentle MDX introduction. The following pages describe in more detail
each MDX function and several features of MDX.

* [Functions Reference](../mdx/functions.md)
* [Language Reference](../mdx/language.md)

_
