## Member Name

Let's take a little break and look at the different ways we have of selecting members in MDX. One disruptive
issue (when starting out as well as later when continuing on with MDX) is the fact that dimension, hierarchies,
levels, and members, are mixed in the syntax.

What does this expression refer to, a dimension, a hierarchy, a level, or a member?

    [Something].[What is This?]

The correct answer is that it could be any of the four. This may not be the clearest solution but this is the way
it works.

Within MDX expressions, members are referred to using *case-insensitive* identifiers: both `Madrid` and `MADRID`
refer to the city `Madrid` within the `Geography` dimension. More details about the actual syntax of the
identifiers can be found later in this page.

Unique member names are used to uniquely refer to a member within the cube and its dimensions/hierarchies.
A *unique name* may be thought of as a path composed of *local names*.

A possible unique name is:

    [Geography].[Geo].[City].[Madrid]

where Madrid has been referenced right from the `City` level.

Let's imagine that all the `continents` were organized into an extra level representing the whole `world`.
We could use the following unique name to refer to `Madrid`:

    [Geography].[Geo].[All].[Europe].[Spain].[Madrid]

You'll notice that no level name has been specified.

#### Identifiers

Identifiers are used to name members and any icCube entity (e.g., dimension, hierarchy, cube, etc...). They are
case insensitive and comply with the following rules. The first character must be a letter or the underscore (`_`)
character. Subsequent characters can be: letters, decimal numbers, the underscore (`_`).

An identifier must not be an MDX reserved keyword. Embedded spaces or special characters are not allowed.

When the name of a member contains reserved MDX characters (e.g., ]) and/or separators, then a *delimited identifier*
has to be used, using square brackets. For example the identifier `Swiss German` (notice the embedded space) must be
named as following:

    [Swiss German]

#### Escaping

Inside a delimited identifier the `[` does not need to be escaped. The `]` character must be escaped by duplicating it.
The identifier:

    [Product[0]]]

is naming the member:

    Product[0]

## Next Step

It's now time to see how to query our multi. dimensional model : [SELECT statement](select_statement.md).

_