## MDX FAQ : How to improve a costly and commonly used FILTERBY statement?

Very often, dashboards include multiple widgets that use the same `FILTERBY` statement, such as the following : 

    FILTERBY NonEmpty( [Item].[Item].[Item], [Measures].[Quantity] )

While this approach is functionally correct, performance can degrade depending on the number of `[Item]` members
and the complexity of the `[Quantity]` measure - especially when this `FILTERBY` is evaluated across multiple widgets.

There is little room to optimize this MDX expression for performance; the `NonEmptyMembers` function may offer
a slight speedup. However, the best approach is to define a static set in the schema (e.g., in the script section).
This ensures the set is computed once and reused across all widgets.

## See Also

- [MDX FAQ](mdx_faq.md)

_
