## MDX FAQ : How to aggregate all members except the unknown member?

A hierarchy is often set up with an `unknown` member that serves as a fallback when building facts. This member
is used for rows that cannot be linked to any existing member. Then, you are more likely to want to compute several
measures using all members except this one. For that purpose, you might be tempted to do something like:

    with member [Measures].[Customer Sales] as
        aggregate (
            except (
                [Customer].[Customer].[Customer]
                [Customer].[Customer].[Unknown]
            ),
            [Measures].[Sales]
        )

While this approach is perfectly valid, what happens when the number of customers reaches several million? 
You guessed it: this expression becomes highly inefficient. Indeed, icCube must compute the required rows
for all selected members.

Fortunately, a faster MDX expression is possible.

Assuming the `[Customer]` hierarchy contains the `[All]` member, and the measure is a `sum`, the following 
expression would be the ideal solution : 

    with member [Measures].[Customer Sales] as
        ( [Measures].[Sales] ) - ( [Customer].[Customer].[Unknown], [Measures].[Sales] )

Indeed, the tuple `( [Measures].[Sales] )` evaluates to the `[Sales]` value for all the members, including 
the `unknown` member. Since the hierarchy includes the `[All]` member, icCube has already indexed the needed 
rows making the actual aggregation extremely fast.

## See Also

- [MDX FAQ](mdx_faq.md)

_