## UnloadPartitions

Unload partitions of a loaded schema.

### URL

    /icCube/api/console/admin/UnloadPartitions

### Parameters

| Name           | Type     | Cardinality | Default Value |
|----------------|----------|-------------|---------------|
| schemaName     | `string` | one         |               |
| dataSourceName | `string` | one         |               |
| dataTableName  | `string` | one         |               |
| partition      | `string` | one-n       |               |
| waitS          | `number` | zero-one    |               |
| cancelS        | `number` | zero-one    |               |

### Return (Payload)

    {
        "schemaName" : "Sales",
        "status"     : "PARTITIONS_UNLOADED"
    }

### Description

This request unload of a list of partitions from a loaded schema.

Table partitions only are supported (i.e., you cannot load/unload level partitions).

On completion, the response contains the status of the operation. Refer to this [page](schema_lifecycle_status.md)
for more details about it. It returns the same status as the LoadPartitions query.

The optional `waitS` and `cancelS` parameters allows for cancelling ongoing requests. A lengthy request might prevent
the actual load (e.g. incremental load, reload, etc..) of the schema. Unless specified otherwise loading a schema
(or partitions) is performed in two steps. The first step is loading the required data and the second step is actually
updating the already loaded schema. The first step can be performed in parallel of ongoing MDX requests but the second
step requires no more requests are accessing the schema. Therefore, the load is stuck until all requests are completed.
These two parameters allows for cancelling the requests before the second step is performed. Before the second step,
icCube waits for `waitS` seconds, then if it cancels the ongoing requests (if any) and waits for `cancelS` seconds.
Then if there is still some ongoing requests the load fails otherwise icCube proceed with the second step.

### See Also

* [LoadPartitions](LoadPartitions.md)
* [Partitions](Partitions.md)

_