## RunNowAlert

Run an alert right now.

### URL

    /icCube/api/console/admin/RunNowAlert

### Parameters

| Name | Type      | Cardinality | Default Value |
|------|-----------|-------------|---------------|
| uuid | `string`  | zero-one    |               |
| name | `string`  | zero-one    |               |
| sync | `boolean` | zero-one    |               |

### Return (Payload)

    {
        "done": true | false,
        "message": "bd51e51c-05e0-4233-ae9f-254a9bb7f41d" | ...
    }

### Description

This request runs an existing alert right now ignoring its actual schedule. Note, you can run a disabled alert.

Either the `uuid` or the `name` of the alert can be used as parameter.

On completion, the alert is asynchronously scheduled (unless the `sync` parameter is being used)  and its UUID
is returned in the `message` field. Otherwise, the response should contain `done:false` and possibly a `message`
explaining the reason.

_