## LoadPartitions

Load partitions of a loaded schema.

### URL

    /icCube/api/console/admin/LoadPartitions

### Parameters

| Name                  | Type      | Cardinality | Default Value |
|-----------------------|-----------|-------------|---------------|
| schemaName            | `string`  | one         |               |
| dataSourceName        | `string`  | one         |               |
| dataTableName         | `string`  | one         |               |
| partition             | `string`  | one-n       |               |
| partitions            | `string`  | one-n       |               |
| timeoutS              | `number`  | zero-one    |               |
| waitS                 | `number`  | zero-one    |               |
| cancelS               | `number`  | zero-one    |               |
| continueBackupOnError | `boolean` | zero-one    |               |

### Return (Payload)

    {
        "schemaName" : "Sales",
        "status"     : "PARTITIONS_LOADED"
    }

### Description

This request performs a (re)load of a list of partitions for a loaded schema.

Table partitions only are supported (i.e., you cannot load/unload level partitions).

Several tables can be specified using the `partitions` parameter:

    partitions: sales 2010 : 2014
    partitions: revenues 2010 2020
    partitions: [sales & revenues] [2010 vs 2020]

The `partitions` parameter supports MDX like notation for escaping names.

On completion, the response contains the status of the operation. Refer to this [page](schema_lifecycle_status.md)
for more details about it. It returns the same status as the LoadPartitions query.

The optional `continueBackupOnError` parameter allows for continuing the backup even if the load
partitions command failed. This command will then be ignored when restoring the backup.

The optional `timeoutS` allows for defining a maximum elapsed time (in seconds) after which the load of the schema
is cancelled and the completion status of the request is error with the `payload.code = UX_TIMEOUT`.

The optional `waitS` and `cancelS` parameters allows for cancelling ongoing requests. A lengthy request might prevent
the actual load (e.g. incremental load, reload, etc..) of the schema. Unless specified otherwise loading a schema
(or partitions) is performed in two steps. The first step is loading the required data and the second step is actually
updating the already loaded schema. The first step can be performed in parallel of ongoing MDX requests but the second
step requires no more requests are accessing the schema. Therefore, the load is stuck until all requests are completed.
These two parameters allows for cancelling the requests before the second step is performed. Before the second step,
icCube waits for `waitS` seconds, then if it cancels the ongoing requests (if any) and waits for `cancelS` seconds.
Then if there is still some ongoing requests the load fails otherwise icCube proceed with the second step.

### See Also

* [UnloadPartitions](UnloadPartitions.md)
* [LoadMeasureGroup](LoadMeasureGroup.md)
* [Partitions](Partitions.md)

_