## Backups

Retrieves the list of schema backups.

### URL

    /icCube/api/console/admin/Backups

### Parameters

| Name   | Type     | Cardinality | Default Value |
|--------|----------|-------------|---------------|
| filter | `string` | zero-n      |               |

### Return (Payload)

    "header": {
        "headers": [
            "group", "schema",  "backupTimestamp", "backupTimestampServerTime", "backupStatus" 
        ]
    },
    "rows": [
        { "cells": [ null, "Sales", "2018-09-17 07-35-58 640 UTC", "2018-09-17 09-35-58 640 CEST", "OK" ] },
        { "cells": [ ...                                                                                ] }
    ]

### Description

This request retrieves the list of schema backups in the icCube server. Both the `group` and `schema` headers
of the response payload can be used in the [filter](./request_format.md#filter) request.

### See Also

* [BackupInfo](BackupInfo.md)
* [DeleteBackup](DeleteBackup.md)
* [LoadedSchemas](LoadedSchemas.md)

_