## BackupInfo

Retrieve some information about a schema backup.

### URL

    /icCube/api/console/admin/BackupInfo

### Parameters

| Name       | Type     | Cardinality | Default Value |
|------------|----------|-------------|---------------|
| schemaName | `string` | one         |               |
| timestamp  | `string` | one         |               |

### Return (Payload)

    {
        "header": {
            "headers": ["property", "value"]
        },
        "rows": [
            { "cells": [ "schema",                    "Sales"                        ] },
            { "cells": [ "group",                     "Demo"                         ] },
            { "cells": [ "backupTimestamp",           "2018-09-17 07-37-57 445 UTC"  ] },
            { "cells": [ "backupTimestampServerTime", "2018-09-17 09-37-57 445 CEST" ] },
            { "cells": [ "backupStatus",              "OK"                           ] },
            { "cells": [ "backupSize",                "13.3MB"                       ] }
        ]
    }

### Description

This request retrieves some information about a schema backup: e.g., its status, etc...

### See Also

* [Backups](Backups.md)
* [DeleteBackup](DeleteBackup.md)
* [LoadedSchemas](LoadedSchemas.md)

_