## On-The-Fly Authorization: Docs

This section is assuming a general understanding of the on-the-fly authorization mechanism. Please refer to this
[page](../OnTheFlyAuthorization.md) for a general presentation.

### HTTP Header

The `docs` HTTP header defines the content of the `Docs` part of the role of the user being connected to icCube:

![Role Definition Docs](./images/role-definition-docs.png)

This HTTP header contains the actual files and folders permissions as defined in the Docs repository.
Those permissions are overriding any permissions defined in the Docs repository itself. Please refer
to this [page](../../server/user_guide/security/docs_permissions.md) for a detailed explanation of the syntax.

### No Header vs Empty Header

If no header is being specified in the request then the permissions defined in the Docs repository are
being used whereas a header with an empty string means the actual Docs permissions of the user are empty
and therefore forbid every access to the Docs content.

### New Lines

Note that when defining those permissions via an HTTP header, you have to merge all the lines together
and separate them with a comma (the header cannot be multi-line). So for example, the following header:

```
-- Standard vs Custom,+dashboard /shared/standard READ,+dashboard /shared/custom WRITE
```

is actually defining the following permissions:

```
-- Standard vs Custom
+dashboard /shared/standard READ
+dashboard /shared/custom WRITE
```

Should you need to use a `,` within your definition, you'll have to **escape** it by doubling it.

### Configuration

The default name of the HTTP header is: `ic3-Docs`. This name can be changed with the following parameter
of the `IcCubeHeaderAuthenticationService` section (`icCube.xml`):

```xml

<param>
    <name>header.docs</name>
    <value>IC3_DOCS</value>
</param>
```

_