## Schema Memory

In icCube, the main part of the memory [heap](MemoryJavaProcess.md) is typically occupied by the loaded schemas.
This document is describing typical memory footprints of schemas and gives advice on how to reduce the amount of 
required memory.

### Overview

The `Loaded Schemas` box in the Admin page shows an estimation of the amount of memory used by 
all the loaded schemas :

![Loaded Schemas](images/loaded-schemas.png)

The `Loaded Schemas` use case is listing all the schemas along with their memory footprint :

![Loaded Schemas Table](images/loaded-schemas-table.png)

Note that the REST [API](../../server/api/LoadedSchemas.md) is giving the same information.

Selecting a single schema is giving access to a brief overview of the internal data of the schema :

![Loaded Schema](images/loaded-schema.png)

### Loading and Reloading a Schema

The memory footprint as displayed above is about a loaded schema. But loading a schema might require more
memory used by internal temporary data structures. This data might be deleted once the schema has been loaded
or kept if incremental load has been activated. The schema statistics are showing this kind of data.

Note that reloading a schema does not unload automatically the previous one until the schema has been fully
reloaded. Take that into account when estimating the required memory when having a large schema.

### Schema Statistics

The `Loaded Schema` use case is giving access to a fully detailed statistics of the memory usage. These statistics
are available via the top right 3-dots icon : 

![Loaded Schema](images/loaded-schema-stats.png)

Before reviewing the statistics, it is better to refresh them to ensure accessing up-to-date information.
You can download these statistics as a file for investigation. This file shows the estimated total memory usage 
as well as a breakdown by dimensions, facts, indices, etc... This file will therefore give you the indicators of 
most used elements of the schema.

**Overview**

A quick overview of the memory usage is available at the beginning of the file :

![Schema Statistics Overview](images/schema-stats.png)

The schema named `[cube2]` is using `537m` that is mainly divided into three parts :
    
    Dimensions :   Member Data   RAM : 6752KB
    Facts      :   Facts Columns RAM :  291MB
    Indices    :   Facts Index   RAM :  240MB

**Details**

After a quick overview, the file is giving some detailed information for each dimension and facts.

For each dimension, you will see the number of members and the memory used by each level and their different
properties (e.g., names, keys, member properties, etc...).

For each fact (aka. measure group), you will see the size of the indices per dimension as well as the size 
of each measure.

Getting familiar with this file should help you understand how the memory is being used and if everything
look as expected : e.g., detecting a very large non-expected dimension, duplicated information between different
levels, etc... In any case, do not hesitate to [contact us](https://www.iccube.com/contact-us/) to help you
understand these statistics.

### Reducing Schema Memory Footprint

The statistics as described in the previous chapter will give you the indicators of most used elements 
of the schema which will be guiding you on the optimization of its memory footprint. You can refer to the 
following [article](https://www.iccube.com/support/optimization-guide-schema-ram-usage) for more details.

### See Also

Please refer to this [page](../MemoryUsage.md) for a series of documents related to the memory usage in icCube.

### Contact Us

Do not hesitate to [contact us](https://www.iccube.com/contact-us/) for some help configuring the memory.

_