## Low RAM/CPU Configuration

This document is explaining how to configure icCube in accordance with low RAM/CPU constraints and is assuming
the reader is familiar with the memory/RAM [usage](../MemoryUsage.md) in icCube.

### RAM/CPU Constraints : 1 GB, 1 CPU, no-swap

Let's use as an example the physical configuration required by one of our customer : an icCube instance has to run
in a Docker container hosted in Azure Container Apps with `1g` of RAM and `1vCPU`. Note that this container has 
`no swap` enabled neither.  This document is not limited to Azure Container Apps deployment : it can be used for 
any other deployment with such limited physical resources (e.g., Kubernetes, Docker Swarm, bare metal, etc...).

### Scenario Overview

One icCube instance corresponds to a single customer's tenant that is using a small schema. Each icCube's
docker is scaled up and down according to its actual usage. Several hundreds of icCube instances can be started 
at any time. The configuration described later in this document has been tested with this customer data; we advise
(stress)testing and possibly adjusting it with your own data and dashboards requirements.

This document does not cover alternative icCube deployments (e.g., large schema, multi-tenants, etc...).
Do not hesitate to [contact us](https://www.iccube.com/contact-us/) for some more details about them.

### JVM Configuration

The Java heap is configured to use `256 MB` of RAM. Note that if printing dashboards (see below in this document)
is not required then more RAM can be used for the heap (e.g., `384m`) :

    java -Xmx256m ...

When using a regular OpenJDK JVM, the default garbage collector (aka., GC) should be fine. You can force 
the serial GC (less demanding regarding the RAM and CPU) :

    java -XX:+UseSerialGC ...

**OpenJ9**

We've noticed that the Eclipse/IBM OpenJ9 JVM is less demanding regarding its RAM usage. As of writing,
OpenJ9 with Java 17 has been tested (Java 21 should be available current december 2023). You can check icCube
docker [images](https://hub.docker.com/r/ic3software/iccube/tags); the tags ending with `-j9` means OpenJ9
is being used by the images.

### icCube MDX Configuration

icCube is configured to process MDX queries in a sequential way to avoid saturating the single CPU and
using too much RAM for nothing. In the `icCube.xml` file :

    <mdxEvalConfiguration>   

        <activeMdxRequestCount>1</activeMdxRequestCount>

        <profile name="global-executor" forkMode="SERVER" default="true">

            <threadCount>0</threadCount>
            <extraThreadCount>0</extraThreadCount>

Note that nothing is changed for the parallel processing of the schema loading as we're assuming the 
schema is quite small and possibly network bound.

### Print Server Configuration

The icCube container is hosting Chrome (or Chromium) used in headless mode for printing dashboards. To limit
the amount of RAM required by Chrome, icCube is configured to print dashboards one by one. In the `icCube.xml` 
file :

    <printComponentConfiguration ...

        <maxActiveCount>1</maxActiveCount>

As of writing, icCube cannot use an external (to the Docker) print server. Once available, this feature
will free some RAM to increase the amount given to the Java heap and therefore allow icCube to host larger
schemas with the same RAM/CPU constraints.

### See Also

Please refer to this [page](../MemoryUsage.md) for a series of documents related to the memory usage in icCube.

### Contact Us

Do not hesitate to [contact us](https://www.iccube.com/contact-us/) for some help configuring the memory.

_