## QA to Production Environment

This document explains how to deploy icCube into Production from a validated QA environment.

**QA Environment**

This environment is where you test the icCube application against data, hardware, and software that closely 
simulate the Production environment and where you allow intended users to test the icCube application.

**Production Environment**

This is where the icCube application is actually available for business use.

### New Data (Schema, Dashboards, etc...)

The QA environment has been validated for new versions of dashboards, schemas, etc... The icCube applications
(both the server and the dashboards/reporting) are the same as the ones in the production environment.

This section assumes the reader is familiar with the [folders](../../server/user_guide/running_iccube/data_directory.md)
used by an icCube server. Deploying the validated icCube installation from its QA environment to the Production 
environment is basically about copying several folders. Basically the whole `icCube-data` folder can be copied except :

    /audit
    /log
    /tmp
    /schemaData

**.lock**

Depending on your actual configuration, you might have noticed the presence of some `.lock` files in the following
folders :

    /backup
    /docsRepository
    
They might be erased if present when the both environments have been stopped. In any case, there is no need to 
copy them.

Before performing this copy, please **stop gracefully the both icCube environments** unless you know what you're 
doing to prevent any corrupted data being transferred.

### New Dashboards/Reporting Application Version

The QA environment has been validated for a new version of the dashboards/reporting application.

This application is actually persisted in the `docsRepository` folder so copying this folder as described
in the section above is enough.  

### New Server Version

The QA environment has been validated for a new version of the icCube server application.

You need to deploy into Production the new icCube server application the same way you've deployed it into 
the QA environment itself before the validation. In case no data has been changed then that should be it. 
Otherwise, continue with the process as described in the "New Data..." section above.

### See Also

If required, you can activate `load-on-startup` and [backups](../../server/user_guide/using/schema_backup.md) 
for the schemas you'd like to restore on icCube startup.  

_