## Embedding icCube: Cookie (Session-Oriented)

In this scenario, we're assuming the host application is _session-based_ which is matching the icCube architecture.

This section assumes a basic knowledge of icCube. You can refer to this [page](../Embedded.md) for an overview about
embedding icCube within a host Web application.

### Authorization Headers

The icCube server has to be configured to retrieve authentication/authorization information via HTTP headers instead of
the login form. You'll have to change your `icCube.xml` for that. More on this later in this document.

Once the host application authenticated the user successfully, it should send dedicated HTTP headers to icCube. This is
typically done in the reverse proxy of the host applications backend. There, the host applications backend should be
able to retrieve from the user's session the information required by icCube
(e.g., the name of a role).

![Overview](./images/embedded-cookie.png)

Be careful to handle properly the HTTP sessions. For example, do not change the role of an existing icCube session.
By default, icCube will throw an error as this is more than likely an unexpected situation.
Please [contact us](https://www.iccube.com/contact-us/) if you'd like to relax this constraint.

**Logout**

We advise to explicitly close existing icCube HTTP sessions. If you want this, then have a look at the
[logout](../../server/api/Logout.md) request of the REST API. This request invalidates/closes the session
of an authenticated user.

**Request Flow**

The following picture is showing a quick overview of the HTTP request flow from the Web browser to icCube.
The backend reverse proxy logic is mainly responsible to convert the session information contained in the `cookie`
into icCube dedicated HTTP headers (i.e., user and role names as configured in this document).

![Overview](./images/embedded-cookie-flow.png)

### icCube Server Configuration (icCube.xml)

You can configure the icCube server with the `bin/icCube.xml` file.

The default servlet filters are responsible to display a `FORM` for unauthenticated users. To change this, you will have
to replace this with a so called `PASSTHROUGH` filter. This filter delegates the hard work to the header authentication
service:

```xml

<filter>
    <filter-name>PASSTHROUGH</filter-name>
    <filter-class>
        crazydev.iccube.server.authentication.passthrough.IcCubePassthroughAuthenticationServletFilter
    </filter-class>
    <init-param>
        <param-name>anonymousLogon</param-name>
        <param-value>false</param-value>
    </init-param>
</filter>
```

Note that all references to `anonymous` login have been removed as well.

The default authentication service uses users and roles as defined within icCube. With the `PASSTHROUGH` filter,
it is replaced by the `IcCubeHeaderAuthenticationService` that uses dedicated HTTP headers to retrieve the name
of the authenticated user and the information required to set up the role.

```xml

<icCubeAuthenticationService>

    <service-class>crazydev.iccube.server.authentication.IcCubeHeaderAuthenticationService</service-class>

    <param>
        <name>header.user</name>
        <value>IC3_USER_NAME</value>
    </param>

    <param>
        <name>header.role</name>
        <value>IC3_ROLE_NAME</value>
    </param>

    <param>
        <name>header.role.onTheFly</name>
        <value>false</value>
    </param>

</icCubeAuthenticationService>
```

Using the above setup, the service uses the HTTP headers `IC3_USER_NAME` and `IC3_ROLE_NAME`. Note that the role
send to icCube in the HTTP header must exist in icCube. For more complex scenarios, where the actual content of
the role is defined on-the-fly (e.g., passing the name of a schema to authorize), please refer to this
[page](../OnTheFlyAuthorization.md) for more details.

See [icCube.xml](./icCube_cookie.xml) for a fully configured file. You can check the actual differences with your
own `icCube.xml` file for a better understanding of the changes.

### Client (Javascript)

The Javascript code of the host application has to be extended to embed icCube dashboards and/or the administration
interface.

**Dashboards**

The simplest integration is to add an `iframe` with permalinks for each dashboard you want to show. If you want more
control over icCube (i.e., open dashboard, sent events to dashboards, react from dashboard events, etc…), you can use
the icCube [API](https://github.com/ic3-software/ic3-reporting-api-embedded/blob/main/doc/Overview.md).

**Administration Interface**

The Server UI (i.e., both the admin. and schema builder interfaces) can be embedded using an `iframe` using the
URL `/icCube/console/` as its `src` attribute. Note that since icCube 9.x, this URL is not limited anymore to
`/icCube/console/` and can be for example `/cs-admin/console/` instead to better support your own reverse proxy logic.

Add the URL parameter `ic3configuration` ([www](../../dashboards/api/embed/EmbeddingConfiguration.md)) to instruct
icCube
the application is being embedded into a host application. The user interface is then configured accordingly (e.g.,
removing/replacing open in new tab, logout, etc...).

### Troubleshooting

In icCube's `bin/log4j.xml` file, you can configure several loggers helping you to understand what's going on in the
server with authenticating/authorizing HTTP requests. You can switch the level of the following loggers:

    <Logger name="icCube.http.request" level="info"/>
    <Logger name="icCube.authorization" level="info"/>

from `info` to `debug` as following:

    <Logger name="icCube.http.request" level="debug"/>
    <Logger name="icCube.authorization" level="debug"/>

This way, you'll be able to review the HTTP headers received by icCube and the activities related to the both the
authentication and authorization. Search for example for `[auth]` in the console.

### Javascript Source Code

The [ic3-demo-embedded-react](https://github.com/ic3-software/ic3-demo-embedded-react) GitHub repository contains the
source code of a live example demonstrating how to embed dashboards (and server administration) into an existing React
application.

### Contact Us

Please do not hesitate to [contact us](https://www.iccube.com/contact-us/) for more details.

_
