## Repetition Widget

### Overview

A repetition widget allows for repeating along one or two axes one or more widgets filtered by the actual values along
the axis.

For examples, see
[the repetition widget example report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FMiscellaneous%2FRepetition+Widget).

### Data

Like any other widget the repetition widget is receiving a [tidy table](../../../tidyTable/TidyTable.md) as input data.
See the section below to see how the repetition widget is extracting one or two axis.

#### Query Builder

Using a single axis is quite straightforward. For example, the following query:

![Repetition One Axis Query Builder](images/repetition-one-axis-query-builder.png)

is resulting in the tidy table:

| Country
| :---    
| France
| Spain

from which the repetition widget is creating a virtual table where each cell is displaying the widgets(s)
added to the repetition widget as following:

| France
| :---              
| Widgets( France )
| Widgets( Spain )

Should you like to have the widgets displayed on a single column instead (that is, vertically instead of horizontally), put `Country` in the _Row_ field or, in Chart options, set the _Visual Column Count_ to `1`.

A two axis query is straightforward even if less intuitive regarding the tidy table. Indeed, the repetition widget is
going to process all the available columns to create its horizontal axis. For example, the following query:

![Repetition Two Axis Query Builder](images/repetition-two-axis-query-builder.png)

is resulting in the tidy table:

| Year | France | Spain
|:---  |:---    |:---
|2019  | -      | -
|2020  | -      | -
|2021  | -      | -

from which the repetition widget is creating a virtual table where each cell is displaying the widgets(s)
added to the repetition widget as following:

|       | France                 | Spain
|:---  | :---                    | :--- 
| 2019 | Widgets( France \/ 2019 ) | Widgets( Spain \/ 2019 )
| 2020 | Widgets( France \/ 2020 ) | Widgets( Spain \/ 2020 )
| 2021 | Widgets( France \/ 2021 ) | Widgets( Spain \/ 2021 )

### Adding Widget(s)

Once the repetition widget query is ready, you can add widget to display by drag & dropping a widget within the
repetition widget box.

Even if the most common use case is to repeat a single widget, you're free to add as many widgets as you like.

### Row/Column Events

The events `@{ic3-repetition-row}` and `@{ic3-repetition-column}` are available within the repeated widget(s)
to filter their query (or to generate a corresponding title). For example, the following query:

![Repetition Events Query Builder](images/repetition-events-query-builder.png)

is displaying the `#Sales` per `City` filtered by both the row value, and the column value inside each cell of the
repetition widget query.

### Inner Widget Events

Events fired in the inner widgets, will only be visible inside the same set of widgets. Each cell has its own set
of independent events.

For example, the repetition widget contains a button filter and a table with an event linking both. The event generated by the
filter will only be applied to the table belonging to the same repetition cell.

If you want events to be visible outside a block you can prefix them with 'ic3g-'. Note that a same event can't be visible both inside and outside of the repetition widget.

### Configuration

The repetition widget can be configured as follows in the _Chart_ tab.

#### Mapping

The input data for the repetition widget can consist of the following items:

_Rows_ \
Contains the items to be displayed on the vertical axis.

_Columns_ \
Contains the items to be displayed on the horizontal axis.

#### Appearance

_Visual Row Count_ \
Number of items on the vertical axis.

_Visual Column Count_ \
Number of items on the horizontal axis.

_Right Padding_ \
Horizontal space between widgets.

_Bottom Padding_ \
Vertical space between widgets.


_
