## Cell Renderers

Table and Pivot Table widgets can display on a cell, instead of the value itself, different cell renderers available
under Transformation > Cell Renderer. 

![Cell Renderers](images/cell-renderers.png)

Check [live cell renderer examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FTable+%26+Pivot+Table%2FTable+Cell+Renderers).

Find below the list of available Cell Renderers.

### Progress Bar

Displays a bar whose width is proportional to the percentage of the value compared to all values of that column, e.g., the cell with the highest value for the column will have a bar with full cell width.

Check the [Progress Bar Renderer](../../../tidyTable/transformations/TransfRendererProgressBar.md) documentation.

### Link

Displays a link. The content is based on Markdown, adding a link that depends on the value or axis is therefore possible.

Check the [Link Renderer](../../../tidyTable/transformations/TransfRendererLink.md) documentation.

### Rating

Displays stars (five by default) and colored stars are proportional to the value of the cell, a similar behavior to the 'Progress Bar renderer' above.

Check the [Rating Renderer](../../../tidyTable/transformations/TransfRendererRating.md) documentation.

### Rich Text

Allows changing font, size, among other text formatters.

Check the [Rich Text Renderer](../../../tidyTable/transformations/TransfRendererRichText.md) documentation.

### Icon

Displays an icon next to the value of the cell. Many options of icons are available by default: circle, arrow, among
others.

Check the [Icon Renderer](../../../tidyTable/transformations/TransfRendererIconSet.md) documentation.

### Spark Lines

Displays an area chart (line with area below). Use spark lines if the content of the cell is not a single value, but a
sequence of values, for example a vector.

Check the [Spark Lines Renderer](../../../tidyTable/transformations/TransfRendererSparkline.md) documentation.

### Custom HTML

Render custom HTML in a table cell.

Check the [HTML Renderer](../../../tidyTable/transformations/TransfRendererHtml.md) documentation.

_
