## AI ChatBot

### Overview

A chatbot for exploring widget's data in plain English using an AI assistant (aka., LLM).

### BETA

This widget is still in **beta** and is not activated by default (see the server configuration later in this document).
Do not hesitate to [contact us](https://www.iccube.com/contact-us/) to improve it.

### Data Confidentiality

Note that icCube is adding the underlying data of the connected widget to the prompt sent to the LLM. Please
review your LLM provider to ensure this is safe regarding your confidentiality policy.

### Configuration

The chatbot can be configured as follows in the _Chart_ tab.

_Widget_ \
The ID of the widget (e.g., ww0) this chatbot is bound to. Once connected to a widget the chatbot is ready
to give you several insights about its data.

_Initial Question_ \
An optional question sent to the AI assistant when the widget is rendering. When coupled with the _Non-Interactive_
option, this allows for creating a widget adding some more information to a widget based on its actual data. This
could, for example, discover some unusual pattern in the underlying data. 

_Non-Interactive_ \
The chatbot is not accepting user input on top of the configured _Initial Question_.

**Advanced**

_Max. Row Count_ \
As previously mentioned, the data of the connected widget is sent to the underlying LLM for analysis. This number
limits the number of rows being sent and therefore the number of **tokens** being generated. You can set the default
value in your own plugin according to the cost of the underlying LLM being used.

### Configuration (Server)

The AI chatbot is activated from the server configuration as defined in the file `icCube.xml` : 

```xml

<aiConfiguration active="true">

    <ollama active="true">

        <url>http://localhost:11434</url>
        <model>qwen2</model>
        <requestTimeoutS>60</requestTimeoutS>

    </ollama>

</aiConfiguration>
```

Please review the content of that file that should be self-explained. Note that the configuration allows 
for connecting to the following LLM providers :

- Ollama (i.e., your own LLM),
- OpenAI,
- Google Gemini.

[Contact us](https://www.iccube.com/contact-us/) if your LLM provider is not available yet and/or if you'd like
to improve the existing configuration.

_
