## Filter: Switch

You can add filters to your report so that users can filter the queries in the report. The switch widget allows to toggle the state of a single setting on or off, or switch between two values.

Check
the [switch live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FFilters%2FSwitch).

### Data

#### Query Builder

A switch widget expects one or two items. In the case of one item, i.e. on/off state, the query would looks like:

![Switch Query Builder single](images/switch-query-1.png)

In the case of two items:

![Switch Query Builder two](images/switch-query-2.png)



#### MDX Query

To build a switch widget from an MDX query, define a query that results on a single item, such as:

```
SELECT
   [Measures].[Amount] ON "MdxBuilderFilterItems"
FROM [Sales]
CELL PROPERTIES CELL_ORDINAL
```
or that results on two items:
```
SELECT
   {[Measures].[Amount], [Measures].[#Sales]} ON "MdxBuilderFilterItems"FROM [Sales]
CELL PROPERTIES CELL_ORDINAL
```
Items can either be measures or members of a dimension.

#### CSV Data Source

You can have a CSV data source by using 'CSV (Table definition)' as the query type. CSV sources do not have MDX
properties, but we can still use them to make filters. Below we show an example that allows for filters with custom MDX.

```
item,               item@uniqueName
Last week of May,   "[Time].[Time].[day].[24 May 2021]:[Time].[Time].[day].[31 May 2021]"
Month of May,       "DESCENDANTS([Time].[Time].[month].[2021 May],1)"
```

Note that `uniqueName` is a case-sensitive syntax.

Read more about embedded data sources and filters
in [Selection from a CSV (Table Definition) DataSource](SelectionFromEmbedded.md).

### Interaction Options

In the _Interaction_ tab, you can change the selection behavior of the filter. 
By default, the initial selection of a single-item switch is the state _off_, and the first item if in a 2-item switch. The user can change the initial selection of the switch by manually selecting the items in _Initial Selection User Defined_.

With _Publish-_ and _Subscribe Selection_ you can connect the filter to events.

### Switch Options

You can edit the labels of your left and right elements on _Label Left_ and _Label Right_. 
_Item_ \
In the item group, you can select the column with items to use in the filter. The _Items_ use items in the builder or the first character column as the default.

#### See Also

See this [page](../../Filters.md#using-filter-widgets-for-defining-mdx-axes) for using filter widgets to define a query's axis.

_
