## How to Use the Filter Panel

With the filter panel, you can filter the charts, tables and other data visualisations in the dashboard. For example,
the following filter,

![img.png](images/filter-panel-example.png)

filters the charts and tables to only show values where Year is 2019 or 2020.

### Usage

Add a filter with the '+ Add Filter' button. Then, search and select the field you want to add a filter for. Clicking the field adds a new item to the filter panel.

Remove all filters with the 'Remove All' button. Confirm the action by clicking 'Yes'.

You can remove a filter with the 'x' button in the data-field selector.

### Possible operators

The possible operators depend on the data-type of the data-field. These are the possible operators:

+ Is Any Of — Include items in the selection
+ Is None Of — Exclude the items in the selection
+ Equals — Keep items that equals the value
+ Not Equals — Keep items that do not equal value
+ Between — Keep items between the start and end value 
+ Greater or Equal — Keep items that are greater than or equal to the value
+ Greater Than — Keep items that are greater than the value
+ Smaller or Equal — Keep items that are smaller than or equal to the value
+ Smaller Than — Keep items that are smaller than the value
+ Contains — Keep items that contain value in the name
+ Not Contains — Keep values that do not contain value in the name
+ Starts With — Keep items where the name start with value
+ Ends With — keep items where the name ends with value
+ Regex — Keep items that pass a regex. Note, the regex starts at the first character of the value and is case-sensitive. <br> examples:
  + Equal to foo — `foo`
  + Start with foo — `foo.*`
  + End with 123 — `.*123`
  + Contain oo12 — `.*oo12.*`
  + Not start with a, b, c, d, e or f — `[^abcdef]`
  + Search `af` case-insensitive — `(?i)af.*`
+ Is Empty — Keep items that are null
+ Is Not Empty — Keep items that are not null


_
