## Filter: Simple Dropdown

You can add filters to your report so that users can filter the queries in the report. 

The simple dropdown widget renders options as a list of items the user can click on in an expanded menu. It can be used
for [natural filtering purpose](../../Filters.md#using-filter-widgets-for-filtering) or
for [defining a query's axis](../../Filters.md#using-filter-widgets-for-defining-mdx-axes).

Check
the [simple dropdown filters live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FFilters%2FSimple+Dropdown).

### Sizing Consideration

The simple dropdown is retrieving once the whole list of items from the server. Therefore it is well suited for small to
medium lists of items. For large lists, use the [Large Dropdown](FilterAutocompleteLazy.md) filter instead.

### Data

#### Query Builder

A simple dropdown widget expects a list of items that the user can select.

![Dropdown Query Builder](images/dropdown-query-builder.png)

#### MDX Query

To build a simple dropdown widget from an MDX query, define a query that results on a list of items, such as:

```
SELECT
   [Geography].[Geography].[Country] ON 0
FROM [Sales]
CELL PROPERTIES CELL_ORDINAL
```

#### CSV Data Source

You can have a CSV data source by using 'CSV (Table definition)' as the query type. CSV sources do not have MDX
properties, but we can still use them to make filters. Below we show an example that allows for filters with custom MDX.

```
item,               item@uniqueName
28 May,             "[Time].[Time].[day].[28 May 2021]"
Last week of May,   "[Time].[Time].[day].[24 May 2021]:[Time].[Time].[day].[31 May 2021]"
Month of May,       "DESCENDANTS([Time].[Time].[month].[2021 May],1)"
```

Note that `uniqueName` is a case-sensitive syntax.

Read more about embedded data sources and filters
in [Selection from a CSV (Table Definition) DataSource](SelectionFromEmbedded.md).

### Interaction Options

In the _Interaction_ tab, you can change the selection behavior of the filter.

You can change the initial selection of the filter by

* manually selecting the items in _Initial Selection User Defined_,
* or by setting a column into _Initial Selection Column_. Items on the row where this column returns true are in the
  initial selection.

With _Publish-_ and _Subscribe Selection_ you can connect the filter to events.

### Simple Dropdown Options

You can choose the variant, and the size of the simple dropdown items in the _Chart_ tab of the editor. You can add your own
variant in the theme, read more in [Theme components](../../../api/plugin/Theme.md#Components).

_Item_ \
In the item group, you can select the column with items to use in the filter. The _Items_ use items in the builder or
the first character column as the default.

_Color_ \
To change the colors of the buttons, you can map a color column in _Color_. This changes the colors of the items in the
menu as well.

_Selection Color_ \
Sets the color of items in the selected state. Leave blank to use the theme's default selection color.

#### See Also

See this [page](FilterAutocompleteLazy.md) for the large dropdown supporting large list of items, and this [page](../../Filters.md#using-filter-widgets-for-defining-mdx-axes) for using filter widgets to define a
query's axis.

_
