## Filter: Date Picker

With a date picker, the user can select a date, or a range of dates. This is useful for filtering date-based widgets,
such as time series. Or for filtering tables.

Check
the [date picker live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FFilters%2FDate+Picker).

### Data

There are several query options for the date picker input:

- [Query Builder](#query-builder)
  - [Level](#level)
  - [Start \& End dates (level)](#start--end-dates-level)
  - [Start \& End dates (measures)](#start--end-dates-measures)
  - [Date intersection](#date-intersection)
  - [Month or Year Picker](#month-or-year-picker)
- [MDX Query](#mdx-query)
- [CSV Data Source](#csv-data-source)


#### Query Builder

The _Dates_ field accepts either members and levels of time dimensions, 
or measures that return start and end dates.

##### Level

If you add a level to _Dates_, the query will automatically construct the range to be from the oldest date to the most
recent date contained in that level.

To filter the available date levels, press the filter icon next to _Dates_.

![DatePicker Filter Icon](images/datepicker-filter-icon.png)

##### Start & End dates (level)
A date picker filter can use a start date and an end date, within a level's range, as input. The example query
in the image below allows the user to pick dates between Jan 2019 and May 2019.

![DatePicker Query Builder](images/datepicker-query-builder.png)

##### Start & End dates (measures)
A date picker filter can use measures that return a start date and an end date as input. 

![DatePicker Two Measures](images/datepicker-measures.png)


##### Date intersection

If you have two or more time dimensions in your schema and you'd like the date picker to return the **intersection** of those date intervals, 
drag & drop the different levels into the _Dates_ field.

For example, if the *Time* dimension gives dates between 1 Jan 2018 and 15 Sept 2022 and the *Purchase Date* dimension between 16 Jan 2018 and 31 Dec 2023,
the returned date interval is therefore 16 Jan 2018 and 15 Sept 2022.

![DatePicker Intersection](images/datepicker-intersection.png)

##### Month or Year Picker

Using a month or year level on the date picker is available. The picker for months will allow for the full month selection:

![Month Picker](images/month-picker.png)

and same for year:

![Year Picker](images/year-picker.png)

Note that the month / year range picker will display the calendar with days for selection, it will however send the month / year range corresponding to the days selected.

For example, if you select Apr 1st 2018 until Dec 5th 2021, the selected month range will be Apr 2018 - Dec 2021 / the selected year range will be 2018 - 2021.


#### MDX Query

The date picker also allows to set an initial date using the query. For this, you'll need to use the following query
statement.

```
SELECT
    {
        [Time].[Time].[Year].&[2018-01-01], -- Start of selectable dates range
        [Time].[Time].[Day].[13 Jan 2018],  -- End of selectable dates range
        [Time].[Time].[Day].[10 Jan 2018]  -- Initial date
    } ON 0
FROM [Sales]
CELL PROPERTIES CELL_ORDINAL
```

#### CSV Data Source

You can use a CSV source by changing the datasource 'Query Type' to 'CSV (Table Definition)'. Take the following CSV as
an example.

```
dates
2020-01-01
2020-01-31
2020-01-24
```

The first row-item is the start of the selectable date range, the second the end, and the third the initial date.

Since the CSV data produces a character column, it must be converted to datetime. You can do this using the column → set
type transformation.

### Date Picker Options
Set the date picker options in the _Chart_ tab of the editor.

_Dates_ \
In _Dates_, you can specify the column with the dates. Automatically, it will take the column from the builder or the first datetime column. The values in this column have the following meaning: 
* the first row contains the start date for the dates the user can choose from. If it is null, or if the table has no first row, then the range has no lower bound.
* the second row contains the end date for the range. If it is null, or if the table has no second row, then the range has no upper bound.
* the third row contains the initial date. If it is null or not there, then it is not used. 
* The fourth row is the initial end date. This works if _Range Picker_ is enabled.

_Options_ \
In this group you can override the settings that might come from the data. You can change the allowed date range (Min. Date and Max. Date). 
Note that the notation for these dates is the notation that is set in _Input Date Format_. _Label_ is the text displayed if the date picker is empty and move to the top left when a date is selected.
_Helper text_ is a text that is displayed below the date picker field.

_Initial Date_ \
Here you set the _Initial Date_  selection. The _Get From_ field specifies if the initial date is set manually or is coming from a shortcut (see below the definition of shortcuts).

_Event_ \
Here you set what to display in the event generated if the user picks a date. Also, you can change the empty behavior.

_Range Picker_ \
With the date picker, you can also allow the user to select a range of dates. Here you can set the initial end date in
the format specified in _Input Date Format_.
The option _Range Picker Direction_ allows to choose how the start and end fields are visually displayed, either vertically, horizontally or auto (automatic switch based on width/height ratio).

_Shortcuts_ \
Shortcuts allow to quickly select a date from a list (e.g., 'Current Date', 'Last 7 Days', 'Last Month'). Lists of shortcuts can be defined in the theme plugin to then be available on _Allowed Shortcuts_, see this [page](../../../api/plugin/DatePickerShortcuts.md).


The _Anchor Date_ is the date from which the periods in the shortcut are related to. By default, it is set to today, meaning shortcuts like 'Last Month' will calculate from one month prior to today.

If your data typically doesn't include today's entries, set the Anchor Date to 'last'. This ensures shortcuts like 'Last 7 days' to be based on the most recent available date. Without this adjustment, shortcuts may be disabled due to the lack of data for today.




_
