## Google: Marker Map

### Overview

A Google Marker Map visualizes data points on a geographical map. It can be used for indicating sales or number of
events per region. Markers can show individual data points or clustered data if there is a large quantity of points.

The [Google Marker Map report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FMaps%2FMarker+Maps)
contains examples of marker maps.

Refer to the [configuration](../../../gettingstarted/Configuration.md) section to configure your API key.

### Data

#### Query Builder

![marker query builder](images/google-map-marker-query-builder.png)

Location should contain the members containing latitude and longitude
as [member properties](../../../../server/mdx/Member%20Custom%20Property.md), use the filter
icon (see image above, green icon) to display the list of available members that contain these properties.

Measure is an optional field that can be used for coloring and/or for the weight (i.e. marker size) for each location.
Per default, each location has the same weight.

#### MDX Query 

Below we show a typical MDX query for a Google Marker Map using the Sales cube. 

```
SELECT
   {[Measures].[Amount]} ON "builderMeasure"
   [Geography].[Geography].[Country].allmembers ON "location"
FROM [Sales]
```

As for the Query Builder above, the location used on the MDX query should contain the longitude and
latitude [member properties](../../../../server/mdx/Member%20Custom%20Property.md).

#### Table Definition

An example for a table definition is the following: 

| latitude | longitude |
| :--- | ---: |
| 37.782551 | -122.445368 |
| 37.782745 | -122.444586 |
| 37.782842 | -122.443688 |
| 37.782919 | -122.442815 |
| 37.782992 | -122.442112 |
| 37.7831   | -122.441461 |
| 37.783206 | -122.440829 |

This data does not have a weight for each location, meaning that each location gets the same weight. Clusters are active by default when using this query mode.

### Configuration

Configure the options for the Google Marker Map chart in the _Chart_ tab. The following groups of options are available.

#### Mapping

The Google Marker Map expects a [tidy table](../../../tidyTable/TidyTable.md) with the following columns:

_Location_ \
Contains the location of data points, where members should have latitude and longitude
as [member properties](../../../../server/mdx/Member%20Custom%20Property.md).

_Latitude_ \
Contains the values for the latitude. Per default, the chart uses the values of the @ic3Lat property.

_Longitude_ \
Contains the values for the longitude. Per default, the chart uses the values of the @ic3Long property.

_Marker Click Event Column_ \
Optional, column used when firing a marker-click event.

#### Appearance

_Map Settings_ \
'Type' allows to define the map look (Satellite, Hybrid, Road Map, etc).

You can set the initial latitude, longitude and zoom in the map as follows. First, get the location and zoom that you want on the map in the widget. Then, click on the widget's top right menu and select 'Set Zoom & Center'.

_Marker Settings_ \
'Marker Fill Color' allows to directly select the column containing colors. If it is not available in your data, marker colors can be set thanks to color transformations, read more [here](../../../howto/Coloring.md).

Various 'Marker Variants' are available. 'Location' is the default (upside down drop with an unfilled circle in its center), other commonly used are 'Circle' and 'LocationOk' (an 'ok' sign in the center of the drop).

You can also define the markers color, opacity, tooltip and scale.

_Use Marker Clusters_ \
'Marker Clusters' create a per-zoom-level clusters if a large amount of markers is geographically close to each other.
You can set the 'Min Cluster Size' and activate or not the 'Zoom on Click'.

### Best practices

#### Clustering Large Amounts of Data

You can activate grouping markers by activating the _Use Marker Clusters_ feature. Fine-tune the _Min Cluster Size_ to a
number that avoids having too many clusters.

_
