## Stacked Bar Chart

### Overview

The stacked bar chart is a good visualization for showing changes in the parts that make a total. A few examples include
showing market shares over time, or showing time-changes in revenue across different subdivisions.

You can find examples of stacked bar
charts [here](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FStacked+Bar).

### Data

#### Query Builder

Below we show a typical mapping on the Query Builder for a stacked bar chart.

![Stacked Bar Query Builder](images/stacked-bar-query-builder.png)

This example sets `Year` on the vertical axis of the chart, shows `#Sales` as the values, and groups by `Category`,
meaning the chart will display a bar for each `Category` stacked on top of each other.


#### MDX Query

Below we show a typical MDX query for a stacked bar chart using the Sales cube.

```
SELECT 
    [Measures].[#Sales] ON 0
    [Time].[Time].[Quarter] on 1
    [Product].[Product].[Category] ON 2
FROM [Sales]
```

To show multiple bar series in the chart, map _X-Axis_ > _Group_ to the column named `Category`. The chart will
automatically map the axis and values.


The next example shows a query for grouped data.

```
SELECT 
    [Measures].[Amount] ON 0
    [Time].[Time].[Year] on 1
    [Product].[Product].[Category] ON 2
FROM [Sales]
```

To show multiple bars per category in the chart, set _Group_ to the column named 'Category'. The chart will
automatically map the axis and values.

#### Table definition

An example for a table definition is the following:

| date | value |
| :--- | ---: |
| 2017-12-31T23:00:00.000Z | 4500 |
| 2017-12-31T23:00:01.000Z | 2690 |
| 2017-12-31T23:00:02.000Z | 7000 |
| 2017-12-31T23:00:03.000Z | 4900 |
| 2017-12-31T23:00:04.000Z | 5000 |
| 2017-12-31T23:00:05.000Z | 5500 |
| 2017-12-31T23:00:06.000Z | 4200 |

To render this example on a date axis, the date column must be converted to a datetime column. For that, use the 'Set
Type' transformation, choose this column, and set it to datetime. The chart will automatically map column 'date' as the
axis labels and column 'value' as the values.

### Configuration

#### Mapping

In 'Chart', you can map the query result to the axes of the chart. These are the possible options.

_Y-Axis_ \
Contains the labels or date-times for the horizontal axis. Per default, the chart uses the first column of either type
character or type datetime.

_X-Axis_ \
Contains the values for the bars. Per default, the chart uses the first column with numeric values.

_Group_ \
Each unique value in this column becomes a new bar series. The series stack on top of each other.

_Level_ \
This divides the axis into a different section for each unique value in this column. Note, this only works when the mapped
column in _Axis_ is of type character.

#### Appearance

Configure the options for the bar chart in the _Chart_ tab. The following groups of options are available.

_X-Axis_ \
See [how to configure the x-axis](../topics/Am4CategoryDateAxis.md).

_Y-Axis_ \
See [how to configure the y-axis](../topics/Am4ValueAxis.md).

_Bar Series_ \
The column set in _Color_ controls the colors of the bars. If _Color_ is undefined, the chart uses the colors from
either the color property of 'Group' or from the default theme palette applied on the values in
_Group_. If _Group_ is unmapped, it takes the default theme color from the palette. See also this [page](../../../howto/Coloring.md) for different coloring methods.

In the option _Tooltip_, you configure the tooltip for hovering the bars in the chart. To actually see the tooltip, the
option _Chart Cursor_ must be enabled. The background-color of the tooltip is the sames as the color of the bullet.

_Legend_ \
See [how to configure the legend](../topics/Am4Legend.md).

_Value Labels_ \
See [how to configure value labels](../topics/Am4ValueLabels.md).

_Trend Line_ \
See [how to configure a trend line](../topics/Am4TrendLine.md).

_X-Axis Range_ \
See [here how to configure a line or range](../topics/Am4ValueAxisRange.md).

_Chart Cursor_ \
See [how to configure the chart cursor](../topics/Am4ChartCursor.md).

_Scrollbar_ \
See [how to configure scrollbars](../topics/Am4Scrollbar.md).

### Best Practices

#### Null and Zero Values

Series in the chart skip null values on the axis, meaning they go directly to their next defined item. This does
not look nice and can cause problems with interpretation. We recommend setting null values to zero with the
transformation in _Column_ > _Replace Null_. Set the 'fill' value to 0.

#### Modelling as Percentages

The stacked bar chart is a good candidate to model shares of a total. Each share represents the percentage of the total,
where the total equals 100%. To make this work, do these two steps:

1. Add the 'Percentage of total' transformation and group by the column set to _Y-Axis_,
2. Set _X-Axis_ > _Value format_ to `#%`.

#### Add Total of Stack

To display the total on top of the stack, follow these steps:

1. Add the 'Group by' transformation, group by the column in _Y-Axis_, aggregate by the column in _X-Axis_ and select
   the 'Sum' operator,
2. Set the total text in _Chart_ > _Value labels_ > _Stack total text_.

#### Multiple Measures

See [Showing multiple measures in a chart](../topics/Am4AddMultiMeasure.md).

_
