## Line Chart

### Overview

A line chart visualises data points over a range of different labels or time. Its most common usage is showing a time
series of some measure, for example, showing the output of a sensor or financial statements over time.

The [line example report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FLine)
contains examples of line charts.

### Data

#### Query Builder

Below we show a typical mapping on the Query Builder for a line chart.

![Line Query Builder](images/line-query-builder.png)

This example sets `Month` on the horizontal axis of the chart, and shows `Amount` as the values.

#### MDX Query 

Below we show a typical MDX query for a line chart using the sales cube. 

```
SELECT 
    [Measures].[Amount] ON 0
    [Geography].[Geography].[Continent] ON 1
FROM [Sales]
```

This example sets `Continent` on the horizontal axis of the chart, and shows `Amount` as the values.

The next example shows a query for grouped data.

```
SELECT 
    [Measures].[Amount] ON 0
    [Time].[Time].[Year] on 1
    [Product].[Product].[Category] ON 2
FROM [Sales]
```

To show multiple lines in the chart, map _X-Axis_ > _Group_ to the column named `Category`. The chart will automatically
map the axis and values.

#### Table Definition

An example for a table definition is the following: 

| date | value |
| :--- | ---: |
| 2017-12-31T23:00:00.000Z | 4500 |
| 2017-12-31T23:00:01.000Z | 2690 |
| 2017-12-31T23:00:02.000Z | 7000 |
| 2017-12-31T23:00:03.000Z | 4900 |
| 2017-12-31T23:00:04.000Z | 5000 |
| 2017-12-31T23:00:05.000Z | 5500 |
| 2017-12-31T23:00:06.000Z | 4200 |

To render this example on a date axis, the date column must be converted to a datetime column. For that, use the
'Set Type' transformation, choose this column, and set it to datetime. The chart will automatically map column 'date' as
the axis labels and column 'value' as the values.


### Configuration

Configure the options for the column chart in the _Chart_ tab. The following groups of options are available.

#### Mapping


The line charts expects a [tidy table](../../../tidyTable/TidyTable.md) with the following columns:

_X-Axis_ \
Contains the labels or date-times for the horizontal axis. Per default, the chart uses the first column of either type
character or type datetime.

_Y-Axis_ \
Contains the values for the line. This field can be set in _Y-Axis_ > _Value_. Per default, the chart uses the first
column with numeric values.

_Group_ \
Optional, create a different line in the chart for each different group in this column.

_Level_ \
This divides the axis into a different section for each unique value in this column. Note, this only works when the mapped
column in _Axis_ is of type character.

#### Appearance

_X-Axis_ \
See [how to configure the x-axis](../topics/Am4CategoryDateAxis.md).

_Y-Axis_ \
See [how to configure the y-axis](../topics/Am4ValueAxis.md).

_Line series_ 
The values for the line series come from the column(s) defined in _Line Values_.

When the data contains groups, you can change the shape for the line series by setting _Shape_ to the group by column. It's also possible to set a numeric column here, then the series takes the *i*th shape available, where *i* is the value found in the column mapped here. 

_Line Color_ controls the colors of the line bullets. The first color in this column, and in the group if grouped, determines
the color for the line. If _Color_ is undefined, the chart uses the colors from either the color property of _Group_ or
from the default theme palette applied on the values in _Group_. If _Group_ is unmapped, it takes the default theme
color from the palette. See also this [page](../../../howto/Coloring.md) for different coloring methods.

In the option _Tooltip_, you configure the tooltip for hovering the line chart. To actually see the tooltip, the option
 _Chart Cursor_ must be enabled. The background-color of the tooltip is the sames as the color of the bullet.

The options _Hide Line Bullets_ hides the bullets by making them invisible.

With _Legend Text_, you can change the name of the series displayed in the legend. 

To show values next to the series names in the legend, you can enable _Show Value in Legend_.

The line's smoothness can also be set on the _Smooth Line Method_ option.

_Legend_ \
See [how to configure the legend](../topics/Am4Legend.md).

_Value Labels_ \
See [how to configure value labels](../topics/Am4ValueLabels.md).

_Trend Line_ \
See [how to configure a trend line](../topics/Am4TrendLine.md).

_Y-Axis Range_ \
See [here how to configure a line or range](../topics/Am4ValueAxisRange.md).

_Chart Cursor_ \
See [how to configure the chart cursor](../topics/Am4ChartCursor.md).

_Scrollbar_ \
See [how to configure scrollbars](../topics/Am4Scrollbar.md).

### Best Practices

#### Using and Formatting a Datetime Axis

Render the horizontal axis as a datetime axis by mapping a column of type datetime to _Axis_. Format the datetime labels
of the axis in the theme at ic3.formatter.amCharts4.dateFormatter. Here, you control the format and the format of the
label indicating a switch in periods.

#### Multiple Measures

See [Showing multiple measures in a chart](../topics/Am4AddMultiMeasure.md).

_

