## Bar Chart

### Overview

A bar chart is a visualization that shows values as bars along a common axis. It is used to compare values over time or
between categories. The human eye can quickly compare sizes of bars, meaning it is a good candidate for questions such
as “What is the largest or smallest?” or “Is there a trend?”.

See
the [bar example report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FBar)
for examples.

### Data

#### Query Builder

Below we show a typical mapping on the Query Builder for a bar chart.

![Bar Query Builder](images/bar-query-builder.png)

This example sets `Continent` on the vertical axis of the chart, and shows `#Customers` as the values, i.e. bar sizes.

#### MDX query

A typical MDX query for the bar chart has one measure on the 0 axis, and a set of members (e.g., a hierarchy, a level,
etc.) on the 1 axis. For example:

```
SELECT 
    [Measures].[Amount] ON 0
    [Geography].[Geography].[Continent] ON 1
FROM [Sales]
```

There is no need to explicitly map the columns _Category_, _Value_ and _Color_. The chart takes per default the first
measure column as the _Value_, and the first date of character column as the _Category_. In the example above, the _Category_ is auto-mapped to `Continent`, and _Value_ is auto-mapped to the measure `Amount`.

#### Grouping

To group the data, you can use an extra column that identifies each group in the data by repeating the same value.
Resulting in that each unique value in the column represents a group in the data.

The following are two examples of queries that have a category and a group (or level).

```
SELECT
  [Measures].[#Licences] on 0
  [Geography].[Classification].[Hemisphere] * [Customer].[Customer].[Type] on 1
FROM [Sales]

```

or

```
SELECT
  [Measures].[#Licences] on 0
  [Geography].[Classification].[Hemisphere] on 1
  [Customer].[Customer].[Type] on 2
FROM [Sales]

```

For both queries, mapping `Type` to _Axis_ and `Hemisphere` to _Group_ gives a correctly grouped bar chart.

#### Table definition

An example for a table definition is the following:

| date | value |
| :--- | ---: |
| 2017-12-31T23:00:00.000Z | 4500 |
| 2017-12-31T23:00:01.000Z | 2690 |
| 2017-12-31T23:00:02.000Z | 7000 |
| 2017-12-31T23:00:03.000Z | 4900 |
| 2017-12-31T23:00:04.000Z | 5000 |
| 2017-12-31T23:00:05.000Z | 5500 |
| 2017-12-31T23:00:06.000Z | 4200 |

To render this example on a date axis, the date column must be converted to a datetime column. For that, use the 'Set
Type' transformation, choose this column, and set it to datetime. The chart will automatically map column 'date' as the
axis labels and column 'value' as the values.

### Configuration

Configure the options for the bar chart in the _Chart_ tab. The following groups of options are available.

#### Mapping

The bar chart expects a [tidy table](../../../tidyTable/TidyTable.md) with the following columns:

_Y-Axis_ \
The values in this column control the size of the bars. This field can be set in _Y-Axis_ > _Value_. Per default, the
chart uses the first column with numeric values.

_X-Axis_ \
Contains the labels or date-times for the horizontal axis. Per default, the chart uses the first column of either type
character or type datetime.

_Group_ \
Optional, add an extra dimension to compare the values against. This clusters bars that have the same value in the
column mapped to _Group_.

_Level_ \
This divides the axis into a different section for each unique value in this column, resulting in a hierarchy on the axis.
Note, this only works when the mapped column in _Axis_ is of type character.

#### Appearance

_Y-Axis_ \
See [how to configure the y-axis](../topics/Am4ValueAxis.md).

_X-Axis_ \
See [how to configure the x-axis](../topics/Am4CategoryDateAxis.md).

_Bar Series_ \
_Color_ contains the colors for each bar. If undefined, the chart uses the colors from either the color property of 
_Group_ or from the default theme palette applied on the values in _Group_. If _Group_ is unmapped, it takes the default
theme color from the palette. See also this [page](../../../howto/Coloring.md) for different coloring methods.

The value in _Tooltip_ is the value shown when hovering over the column when the _Chart Cursor_
is enabled.

_Legend_ \
See [how to configure the legend](../topics/Am4Legend.md).

_Value Labels_ \
See [how to configure value labels](../topics/Am4ValueLabels.md).

_Trend Line_ \
See [how to configure  a trend line](../topics/Am4TrendLine.md).

_X-Axis Range_ \
See [here how to configure a line or range](../topics/Am4ValueAxisRange.md).

_Chart Cursor_ \
See [how to configure the chart cursor](../topics/Am4ChartCursor.md).

_Scrollbar_ \
See [how to configure scrollbars](../topics/Am4Scrollbar.md).

### Best Practices

#### Grouping Categories

By grouping the data, it becomes more natural to compare the groups against each other. To facilitate this, we recommend
keeping the number of items per group smaller than 5. Also, use a legend to make it clear what bar represents what
group. For the colors, use a categorical color palette that does not suggest any ordering between the groups.

#### Axis Origin

Always show zero on the value axis. This way, the size of a bar relative to another bar is the same as the relative
difference in values.

#### Sorting

For a non-date y-axis, it is visually interesting to have the data sorted in order to compare categories. To achieve
this, add the transformation in Table > Sort. Then, sort on the column that contains the values for the bars.

#### Multiple Measures

See [Showing multiple measures in a chart](../topics/Am4AddMultiMeasure.md).

_
