## Gantt Chart

### Overview

A gantt chart is a bar chart used for displaying time-based data, such as project schedules. Each bar represents a task with start and end dates/periods.

For examples,
see [the gantt example report](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FGantt).

### Data

#### Query Builder

Below we show a typical mapping on the Query Builder for a gantt chart.

![Gantt Query Builder](images/gantt-query-builder.png)

This example sets `Type` as the gantt bars, with `Start` and `End` the values. Note that _Start Value_ and _End Value_ need to be of date or datetime type. You can use the [Set Type](../../../tidyTable/transformations/TransformationSetType.md) transformation if needed.


#### MDX Query

The gantt chart expects a [tidy table](../../../tidyTable/TidyTable.md) with two measures.

```
SELECT
   {[Measures].[Start], [Measures].[End]} ON 0
   [Customer].[Customer].[Type] ON 1
FROM [Sales]
```

This produces the following tidy table.

|Type<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Start<br><span style="font-weight:normal;color:gray">&lt;date/time&gt;</span>|End<br><span style="font-weight:normal;color:gray">&lt;date/time&gt;</span>|
|:---|:---|:---|
|Business|23 September 2038|21 August 2113|
|Consumer|23 March 2032|14 February 2081|

#### Grouping
To create a gantt chart with groups, add an element in the _Group_ field, for example, `Continent`.

![Gantt Groups Query Builder](images/gantt-groups-query-builder.png)

The equivalent MDX query can be written as follows:

```
SELECT
   {[Measures].[Start], [Measures].[End]} ON 0
   [Customer].[Customer].[Type] ON 1
   [Geography].[Geography].[Continent] ON 2
FROM [Sales]
```

This produces the following tidy table.

|Type<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Continent<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Start<br><span style="font-weight:normal;color:gray">&lt;date/time&gt;</span>|End<br><span style="font-weight:normal;color:gray">&lt;date/time&gt;</span>|
|:---|:---|:---|:---|
|Business|Africa|01 November 2022|03 March 2034|
|Business|Asia|12 October 2020|26 November 2023|
|Business|Europe|03 January 2030|13 January 2070|
|...|...|...|...|
|Consumer|North America|08 August 2022|02 January 2033|
|Consumer|Oceania|09 June 2020|11 March 2022|
|Consumer|South America|11 March 2020|16 December 2020|

The gantt chart auto-maps `Type` to _Axis_ and `Continent` to _Group_ under _Chart_ > _Y-Axis_.

#### Table Definition

An example for a table definition is the following:

| Group | Task | Start | End |
| :--- | :--- | :--- | :--- |
| Data | Data integration | 17.10.2023 | 20.10.2023
| Data | Schema, Analytics & Calculations | 20.10.2023 | 30.10.2023
| Dashboards | Dashboard creation | 30.10.2023 | 10.11.2023
| Dashboards | Custom branding | 05.11.2023 | 13.11.2023
| Dashboards | Host-icCube communication | 10.11.2023 | 13.12.2023
| Integration | User Management | 30.10.2023 | 11.11.2023
| Integration | Dashboards Integration | 01.11.2023 | 07.11.2023
| Integration | Performance & Scalability| 04.11.2023 | 17.11.2023
| DevOps | Environment setup | 20.10.2023 | 05.11.2023
| DevOps | Data Processing | 26.10.2023 | 10.11.2023

To render this example, the `Start` and `End` columns must be converted to a datetime column. For that, use the [Set Type](../../../tidyTable/transformations/TransformationSetType.md) transformation, choose these columns, and set them to datetime. 

### Configuration

#### Mapping

The stacked column chart expects a [tidy table](../../../tidyTable/TidyTable.md) with the following columns:

_Start Value_ \
Contains the starting date/period values of each bar.

_End_ Value_ \
Contains the ending date/period values of each bar.

_Axis_ \
Contains the labels for the vertical axis. Per default, the chart uses the first column of type
character.

_Group_ \
Optional, add an extra dimension to compare the values against. This clusters bars that have the same value in the
column mapped to _Group_.

#### Appearance

_Y-Axis_ \
See [how to configure the y-axis](../topics/Am4ValueAxis.md).

_X-Axis_ \
See [how to configure the x-axis](../topics/Am4CategoryDateAxis.md).

_Gantt Series_ \
_Color_ contains the colors for each bar. If undefined, the chart uses the colors from either the color property of 
_Group_ or from the default theme palette applied on the values in _Group_. If _Group_ is unmapped, it takes the default
theme color from the palette. See also this [page](../../../howto/Coloring.md) for different coloring methods.

The value in _Tooltip_ is the value shown when hovering over the column when the _Chart Cursor_
is enabled.

When you have grouping in your Gantt chart, you can have the groups on a single lane instead of a separate lane, i.e. 'stacked' bars iinstead of disjoint bars. To
use this, activate the _Groups in Single Lane_ option.

_Legend_ \
See [how to configure the legend](../topics/Am4Legend.md).

_Value Labels_ \
See [how to configure value labels](../topics/Am4ValueLabels.md).

_Chart Cursor_ \
See [how to configure the chart cursor](../topics/Am4ChartCursor.md).

_Scrollbar_ \
See [how to configure scrollbars](../topics/Am4Scrollbar.md).

### Best practices

#### Grouping Categories

By grouping the data, it becomes more natural to compare the groups against each other. To facilitate this, we recommend
keeping the number of items in each group smaller than 5. Also, use a legend to make it clear what bar represents what
group. For the colors, use a categorical color palette that does not suggest any ordering between the groups.

_
