## Divergent Bar Chart

### Overview

The divergent bar chart is useful when comparing either two measures, or when comparing a single measure for two groups. The latter is common with population pyramids. For example, below we show the age distribution of passengers that boarded the Titanic. 

![](images/divergent-bar-example.png)

_Sourced from https://www.kaggle.com/c/titanic._

### Data

#### Query Builder — two measures

Below we show an example of a query in the query builder. 

![img.png](images/divergent-builder.png)

This example shows `#Sales` as the left value and `#Customers` as the right value.

#### Query Builder — same measure for two groups

You add two calculated measures, one for each group, to the left- and right value respectively. In the query builder, this looks as follows: 

![](images/divergent-bar-two-groups.png)

Here, `Amount Business` is the amount measure, but filtered for the business customer types. It has the following MDX,

```
([Customer].[Customer].[Type].&[Business], [Measures].[Amount])
```

The amount for the consumers has a similar MDX statement, but using the Consumer member instead of the Business member.

The same result can be achieved by directly dragging and dropping the Business and Consumer members as left and right values, and the measure as a filter:

![](images/divergent-bar-measure-as-filter.png)

Best practices for the divergent bar chart are to remove empty rows, and to order the axis members for better readability.


### Configuration

Configure the options for the bar chart in the _Chart_ tab. The following groups of options are available.

_Y-Axis_ \
See [how to configure the y-axis](../topics/Am4ValueAxis.md).

_X-Axis_ \
See [how to configure the x-axis](../topics/Am4CategoryDateAxis.md).

_Divergent Bar Series_ \
You can change the color of the bars by setting either the header color, or the cell colors on the column. You can do
this with a color transformation, see [here](../../../tidyTable/transformations/Transformations.md).

The value in _Tooltip_ is the value shown when hovering over the column when the _Chart Cursor_
is enabled.

_Legend_ \
See [how to configure the legend](../topics/Am4Legend.md).

_Value Labels_ \
See [how to configure value labels](../topics/Am4ValueLabels.md).

_Trend Line_ \
See [how to configure  a trend line](../topics/Am4TrendLine.md).

_X-Axis Range_ \
See [here how to configure a line or range](../topics/Am4ValueAxisRange.md).

_Chart Cursor_ \
See [how to configure the chart cursor](../topics/Am4ChartCursor.md).

_Scrollbar_ \
See [how to configure scrollbars](../topics/Am4Scrollbar.md).

_
