## Bubble Chart

### Overview

The bubble chart is similar to the scatter plot. It plots items as bubbles based on their x and y coordinates, and it
sets the size of each bubble according to a value of the item. For example, if each item is a country with GDP as the
y-coordinate, and population size as the x-coordinate. Then the size of the bubble can represent the area of the country
in square kilometers. In this example, the bubble plot nicely visualises the correlation between population, GDP and
size in the set of countries.

For examples based on the sales dataset, have a look
at [this](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FCharts%2FBubble)
report.

### Data

#### Query Builder

Below we show a typical mapping on the Query Builder for a bubble chart.

![Bubble Query Builder](images/bubble-query-builder.png)

This example sets `#Sales` on the horizontal axis of the chart, `Amount` on the vertical, and `Amount AVG` as the bubble
sizes.

To create a bubble chart with groups, add an element in the 'Group by' field, for example, `Type`.

#### MDX Query

The bubble chart expects a [tidy table](../../../tidyTable/TidyTable.md) with at least three measures. The best way to achieve this is to set these three measures on the 'ON 0' axis, like so. 

```
SELECT
{[Measures].[Amount], [Measures].[#Sales], [Measures].[Amount AVG] } ON 0
[Time].[Time].[Month] ON 1
FROM [Sales]
```

This next example shows a valid MDX query for a bubble chart containing groups.

```
SELECT
{[Measures].[Amount], [Measures].[#Sales], [Measures].[Amount AVG] } ON 0
[Time].[Time].[Month] ON 1
[Customer].[Customer].[Type] ON 2
FROM [Sales]
```

This produces the following tidy table.

|&nbsp;|Month<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Type<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|#Sales<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Amount AVG<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|---:|---:|
|0|2018 Jan|Business|€54,000|16|€3,375|
|1|2018 Jan|Consumer|€5,050|13|€388|
|2|2018 Feb|Business|_\<null>_|_\<null>_|_\<null>_|
|...|...|...|...|...|...|
|111|2022 Aug|Consumer|€4,000|16|€250|
|112|2022 Sep|Business|_\<null>_|_\<null>_|_\<null>_|
|113|2022 Sep|Consumer|€1,200|1|€1,200|

The bubble chart automatically maps `Month` to _Label_, `Amount` to _X-value_, `#Sales` to _Y-value_ and `Amount AVG` to _Size_. As the data contains groups, you'll have to map `Type` to _Group by_ yourself.

### Configuration

Configure the options for the donut chart in the _Chart_ tab. The following groups of options are available.

#### Mapping

The bubble chart expects a [tidy table](../../../tidyTable/TidyTable.md) where each row is a bubble in the chart. Each row has the following columns.

_Label_ \
The label of the bubble.

_X-value_ \
The x-coordinate of the bubble.

_Y-value_ \
The y-coordinate of the bubble.

_Size_ \
The size of each bubble. Larger values have bigger bubbles. 

_Group by_ (optional) \
The group that the bubble belongs to. Each group gets a different color and a different label in the legend.

#### Appearance

_X-Axis_ \
See [how to configure the x-axis](../topics/Am4CategoryDateAxis.md).

_Y-Axis_ \
See [how to configure the y-axis](../topics/Am4ValueAxis.md).

_Bubble series_ \
In _Color_, you can set the color of the bubble. If you set a transformation on one of the columns in the table, then
this will auto map to that color. See also this [page](../../../howto/Coloring.md) for different coloring methods.

_Legend_ \
See [how to configure the legend](../topics/Am4Legend.md).

_Value Labels_ \
See [how to configure value labels](../topics/Am4ValueLabels.md).

_Trend Line_ \
See [how to configure a trend line](../topics/Am4TrendLine.md).

_Chart Cursor_ \
See [how to configure the chart cursor](../topics/Am4ChartCursor.md).

_Scrollbar_ \
See [how to configure scrollbars](../topics/Am4Scrollbar.md).

_
