## Transformations

You can modify the query result with transformations. Each transformation alters the table, or changes some properties
of a column. You can stack one or more transformations, each transformation uses the output of the previous
transformation as its input. The first step in the transformations uses the query result as input.

Note that transformations are processed in the order they are added, so the sequence of transformations is important. 
Cell renderer transformations are an exception and are always processed **last**, regardless of their position in the sequence.

The following transformations are available.

### Color

Color transformations add colors or to modify the existing colors of a columns.

* **Single Color**  
  Set all cells in a column to a single color. Read more [here](TransformationColorSingle.md).

* **Categorical Color**  
  Loop over the palette. For character columns, each unique value gets a color. For numeric columns, it takes the nth
  color in the palette. Read more [here](TransformationColorCategorical.md).

* **Ordinal Color**  
  Calculate colors for the values in an ordinal column. Use this transformation if the column's values have a natural
  order, for example, worst < neutral < best. Read more [here](TransformationColorOrdinal.md).

* **Numeric Color**  
  With this transformation you can map numeric values to a color. If you use a single color, then you can scale it by
  making the color darker for larger values, and lighter for smaller values. If you use a palette, then the
  transformation interpolates the colors. The smallest value gets the first color on the palette, and the largest the
  last color. It interpolates the other values. Read more [here](TransformationColorNumeric.md).

* **Conditional Color**  
  Add color rules on a column. Read more [here](TransformationColorConditionalRule.md).

* **Conditional Color JS**  
  Choose a color depending on an expression. Read more [here](TransformationColorConditionalJS.md).

* **Copy Column Color to Table**  
  Copy a column color to all table columns. Read more [here](TransformationColorColumnToTable.md).

* **Modify Color**  
  Darkens or lightens existing colors. Read more [here](TransformationTransformColor.md).

* **Set Missing Colors**  
  This transformation works like the 'replace nulls' transformation. Except here, you can select a theme-color as the
  replacement value. Read more [here](TransformationSetMissingColor.md).

* **Clear Header/Cell Colors**  
  Clears the color from columns. Read more [here](TransformationClearColor.md).

* **Set Header Color**  
  Set the color of the header of a column. Read more [here](TransformationSetHeaderColor.md).

### Column

Column transformations work on a single column.

* **Add a Column**  
  Create a new column from an expression. Read more [here](TransformationAddColumn.md).

* **Add Total Column**  
  Create a new column as the row-aggregation of the table column values, properties or measures. Read more [here](TransformationAddAnAggregationColumn.md).  

* **Delete a Column**  
  Remove a column or property from the table. Read more [here](TransformationDeleteColumn.md).

* **Copy a Column**  
  Copy the column. Read more [here](TransformationCopyColumn.md).

* **Shift Values**  
  move each value n rows forward. Value n can be positive or negative. Read more [here](TransformationShift.md).

* **Modify Values**  
  Apply a function to each value in the column. Read more [here](TransformationApplyFunction.md).

* **Percentage of Total**  
  Calculate the percentage w.r.t. the columns total. Read more [here](TransformationPercentageOfTotal.md).

* **Percentage of Row**  
  Calculate the percentage of each selected column using the row-total. Read more [here](TransformationPercentageOfRow.md).

* **Add Property**  
  Create a new property for a column. Read more [here](TransformationAddProperty.md).

* **Localize Values**  
  Translates column values to the user locale. Read more [here](TransformationTranslate.md).

* **Bucket Values**  
  Put the values in (user defined) buckets, e.g., 6 → '1 – 10', 12 → '11 – 20'. Read
  more [here](TransformationHistogramBuckets.md).

* **Set Caption**  
  Change the caption of a column. Read more [here](TransformationSetCaption.md).

* **Set Format**  
  Change the number/date format of a column. Read more [here](TransformationSetNumberFormat.md).

* **Set Type**  
  Change the data-type of a column. Read more [here](TransformationSetType.md).

* **Cumulative Sum**  
  Calculate the cumulative sum of a numeric column. Read more [here](TransformationCumulativeSum.md).

* **Replace Nulls**  
  Replace all the null values in the column with a single value. Read more [here](TransformationReplaceNull.md).

* **Search and Replace**  
  Replace values with other values. Read more [here](TransformationSearchAndReplace.md).

* **Mark Total Column**  
  Choose columns that are rendered as bold total columns. Read more [here](TransformationMarkTotalColumn.md).

* **Add Tooltip Property**  
  Show a tooltip to the user when hovering the cell. Read more [here](TransformationAddTooltipProperty.md).

### Table

Table transformations change the structure of the table.

* **Rank**  
  add a ranking column based on the sorting order of one or more columns. Read
  more [here](TransformationRankValues.md).

* **Pivot Longer**  
  Move columns to rows. Read more [here](TransformationPivotLonger.md).

* **Pivot Wider**  
  Move rows to columns. Read more [here](TransformationPivotWider.md).

* **Group By**  
  Aggregate the table by grouping and combine the result. Read more [here](TransformationGroupBy.md).

* **Change Column Order**  
  Change the order of the columns. Read more [here](TransformationOrderColumns.md).

* **Group to Other**  
  Group values below a threshold to 'Other' (handy in Donut/Pie charts). Read more [here](TransformationGroupToOther.md).

* **Sort**  
  Allows for sorting/ordering the table. Read more [here](TransformationSortTable.md).

* **Histogram**  
  Transform the table to make a histogram chart. Read more [here](TransformationHistogram.md).

* **Add (Sub)Totals**  
  Add rows with (sub)totals to your table. Read more [here](TransformationAddTotal.md).

* **Filter Nulls**  
  Remove rows with null values in all the columns selected. Read more [here](TransformationFilterNull.md).

* **Mark Total Row**  
  Choose rows that are rendered as bold total rows. Read more [here](TransformationMarkTotalRow.md).

* **Add a Row**  
  Create a new row from an expression. Read more [here](TransformationAddRow.md).  

* **Group Data Points**  
  Assign the same group to rows with a low proximity. Read more [here](TransformationMergeCloseDataPoints.md).  

### Cell Renderer

Cell renderers change how a table renders the cell.

* **Progress Bar Renderer**  
  A renderer showing a percentage bar with a text. Read more [here](TransfRendererProgressBar.md).

* **Link Renderer**  
  A renderer showing a text with a link. Read more [here](TransfRendererCustom.md).

* **Rating Renderer**  
  A renderer showing a rating with stars. Read more [here](TransfRendererRating.md).

* **Rich Text Renderer**  
  A rich text cell renderer. Read more [here](TransfRendererRichText.md).

* **Icon Renderer**  
  A cell content with an icon. Read more [here](TransfRendererIconSet.md).

* **Spark Line Renderer**  
  Render a cell in a table as a sparkline. Read more [here](TransfRendererSparkline.md).

_
