## Transformation: Sort

You can sort a table with the sort function. For this, you select one or more columns and a sorting orders to sort the
table. The transformation starts by sorting the first column, then if two items are equal it sorts based on the second
column, and so forth until the last column in the list.

#### Null Values

The transformation sorts _Null_ values last if the order is descending and first if the order is ascending.

#### Hierarchical Structures

Activate the _Hierarchical Sort_ flag if applying this transformation to pivot tables or other charts displaying or allowing to drill down into hierachical structures.

#### Example

For an example, we use this table about hotel reservations.

|<b></b>|name<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|arrival date<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|hotel room<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Nights<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|tip<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|breakfast y/n<br><span style="font-weight:normal;color:gray">&lt;logical&gt;</span>|
|:---|:---|:---|:---|---:|---:|:---|
|0|Kamile Sanford|1999-04-21|suite A|5|_\<null>_|true|
|1|Kody Tucker|1999-03-01|suite B|4|_\<null>_|true|
|2|Mandy Hewitt|1999-10-29|suite B|5|_\<null>_|true|
|3|Payton Sellers|1999-11-14|suite B|5|11.07|false|
|4|Jarrad Chang|1999-05-07|suite B|4|8.47|true|
|5|Hakeem Whitley|1999-10-27|suite C|2|_\<null>_|true|
|6|Fred Pruitt|1999-03-26|suite B|5|10.55|false|
|7|Mina Guevara|1999-09-13|suite C|3|_\<null>_|true|
|8|Flynn Oakley|1999-10-26|suite C|3|10.78|true|
|9|Hector Stuart|1999-10-07|suite A|1|11.87|true|

We sort it on the hotel room and the tip with the following settings. In the 'Order' setting, the *n*th item is the
sorting order for the *n*th column in 'Columns'.

![](images/sort-settings.png)

This results in the following table. As you can see, it sorted the column 'hotel room' in ascending order. Where the
hotel rooms are equal, it sorted based on the tip column.

|<b></b>|name<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|arrival date<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|hotel room<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Nights<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|tip<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|breakfast y/n<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|
|:---|:---|:---|:---|---:|---:|:---|
|0|Hector Stuart|1999-10-07|suite A|1|11.87|true|
|1|Kamile Sanford|1999-04-21|suite A|5|_\<null>_|true|
|2|Payton Sellers|1999-11-14|suite B|5|11.07|false|
|3|Fred Pruitt|1999-03-26|suite B|5|10.55|false|
|4|Jarrad Chang|1999-05-07|suite B|4|8.47|true|
|5|Kody Tucker|1999-03-01|suite B|4|_\<null>_|true|
|6|Mandy Hewitt|1999-10-29|suite B|5|_\<null>_|true|
|7|Flynn Oakley|1999-10-26|suite C|3|10.78|true|
|8|Hakeem Whitley|1999-10-27|suite C|2|_\<null>_|true|
|9|Mina Guevara|1999-09-13|suite C|3|_\<null>_|true|

### See Also

[Rank](TransformationRankValues.md)

_
