## Transformation: Set Format

Change the formatting of a numeric or date column. How the format is applied depends on the type of the column. If the column is `numeric`, then the transformation applies a _number format_. If the column is `date/time`, then it applies a _date format_.

#### Number Format

A number format is a string with `#` indicating a number, `,` indicating the thousand separator, and `.` indicating the
decimal separator. After the decimal, number for `#` are optional and will be rounded to the nearest mandatory decimal
indicated by `0`.

Do not use the decimal or thousands separator of your own language. The application replaces `.` and `,` with the separators based on the users browsing language. For example, in French, `#.###` formats 1234.56 as 1 234,56 (notice the space as thousands separator and the comma as decimal separator).

For more information, see the amCharts number formatting documentation (note # behaves like #. in amcharts):
https://www.amcharts.com/docs/v4/concepts/formatters/formatting-numbers/. 

Examples:

- **integer** `#`

  2361.2983 → 2362

- **two decimals** `#.00`

  2361.2983 → 2361.30

- **thousands/millions** `#.0a`

  2361.2983 → 2.4k

- **currency** `€#,###.00`

  2361.2983 → €2,361.30

- **scientific format** `#.##e`

  2361.2983 → 2.36e+3

- **bytes** `#.b`

  2361.2983 → 2KB

#### Date Format

Date formats are localized for day and month names and use a similar format than the one in the Server and have no time
zone

Examples:

- **Month-Day-Year** `MM/dd/yyyy`

  date(2020, 1, 10) → 01/10/2020

- **Day-Month-Year** `dd/MM/yyyy`

  date(2020, 1, 10) → 10/01/2020

- **Year-Month-Date** `yyyy MM dd`

  date(2020, 1, 10) → 2020 01 10

- **4 digit Year** `yyyy`

  date(2020, 1, 10) → 2020

- **2 digit Year** `yy`

  date(2020, 1, 10) → 20

- **Quarter** `Q`

  date(2020, 1, 10) → 1

- **Month** `MMM`

  date(2020, 1, 10) → Jan

- **Month** `MMMM`

  date(2020, 1, 10) → January

- **1 or 2 digit day** `d`

  date(2020, 1, 1) → 1

- **2 digit day** `dd`

  date(2020, 1, 1) → 01

- **day name in the week** `E`

  date(2020, 1, 1) → Mon

- **day name in the week** `EEEE`

  date(2020, 1, 1) → Monday

- **2 digit day** `dd`

  date(2020, 1, 1) → 01

- **Hour:Minute:Second** `HH:mm:ss`

  date(2020, 1, 10, 4, 32, 0) → 04:32:00

- **Adding text with ' character** `'Q'Q`

  date(2020, 1, 10) → Q1

- **Adding the ' character** `''yyyy`

  date(2020, 1, 10) → '2020

There is one difference from the server, **YYYY** is not using the Week year but the standard year and time zone
related pattern are not available.

### Excel Format

When exporting to Excel, the default is to use the format of the column, e.g., the one you set in 'Format'. However, not
all formats also work in Excel, for example, Excel parses 40000 with `#a` as `40000a` instead of `40k`.

By using the field 'Format (Excel)', you can correct for this.

### See Also

[Add Property](TransformationAddProperty.md),
[Set Caption](TransformationSetCaption.md),
[Set Type](TransformationSetType.md)

_