## Transformation: Replace Nulls

Use this transformation to replace all _\<null\>_ values in the column.

For example, if we have the following table.

|&nbsp;|Quarter<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|
|:---|:---|:---|
|0|2018 Q1|_\<null>_|
|1|2018 Q2|102400|
|2|2018 Q3|_\<null>_|

We set _Columns_ to `Amount` and _Value_ to `0`, then we get the following result.

|&nbsp;|Quarter<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|
|:---|:---|:---|
|0|2018 Q1|0|
|1|2018 Q2|102400|
|2|2018 Q3|0|

##### Typed columns

For columns of type list, date or number, the transformation parses the replacement value. For example, in list columns, `[1,2,3]` gets parsed as `[1, 2, 3]`. In date columns, `1995-12-17T03:24:00` gets parsed as a date. 

### See Also

[Set Missing Colors](TransformationSetMissingColor.md),
[Filter Nulls](TransformationFilterNull.md)

_