## Transformation: Group Data Points

This transformation assigns rows with a low proximity to each other into the same group.

### Examples

We use the following input table. We use the `Amount` and `#Licenses` columns as input.

|&nbsp;|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|#Licences<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|---:|---:|
|0|€54,000|60|
|1|€12,000|12|
|2|€104,400|126|
|3|€11,200|13|
|4|€44,800|52|
|5|€10,000|10|

The transformation assigns the same group to rows with a low proximity. Rows are close to each other if the Manhattan distance for two column values is below the threshold. Mathematically, this means that: 

```
row_a isCloseTo row_b <==> for every column i : | row_ai - row_bi | < max_distance_i * threshold
```
where 
 * `row_xi` is the value of row `x` at column `i`, and
 * `max_distance_i` equals `| max_col_i - min_col_i |`

In the example, this results in the following groups:

|&nbsp;|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|#Licences<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|group<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|---:|---:|---:|
|0|€54,000|60|0|
|1|€12,000|12|1|
|2|€104,400|126|2|
|3|€11,200|13|1|
|4|€44,800|52|4|
|5|€10,000|10|1|

Rows `1, 3, 5` received the same group ID because these rows are close to each other.

### See Also

[Group By](TransformationGroupBy.md)

_