## Transformation: Add Bucket Column

Use this transformation to add a new column with buckets, or intervals, representing each value of the input column (
text format).

If you aim to create a histogram that counts the points in each bucket, you can use
the [Histogram](TransformationHistogram.md) transformation.

The transformation has two possible methods for defining the intervals:

- **Automatic**: divide the interval of the minimum to the maximum of the input column in _n_ equally sized,
  non-overlapping buckets.
- **User defined**: create your own buckets, for example

```json
 [
  {
    "to": 10
  },
  {
    "from": 10,
    "to": 100
  },
  {
    "from": 100
  }
]  
```

The transformation uses the formatting from the column set in _Column_ for formatting the interval names. 

For example, we use the following table with _Bucket Count_ equal to `2`.

|&nbsp;|Quarter<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|---:|
|0|2018 Q1|€83,100|
|1|2018 Q2|€102,400|
|2|2018 Q3|€179,350|

Then, we get the following result with `Amount` as _Column_.

|&nbsp;|Quarter<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|bucket<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|
|:---|:---|---:|:---|
|0|2018 Q1|€83,100|€83,100 - €131,225|
|1|2018 Q2|€102,400|€83,100 - €131,225|
|2|2018 Q3|€179,350|€131,225 - €179,350|

### See Also

[Histogram](TransformationHistogram.md),
[Add a Column](TransformationAddColumn.md),
[Modify Values](TransformationApplyFunction.md),

_