## Transformation: Group to Other

You can use the group to other transformation to combine categories to the 'Other' group. This is useful in for example the donut chart if you have many categories. Instead of displaying many slices, the chart will show only the 'Other' slice after using this transformation.  

#### Example

Say we have the following table about hotel reservations.

|<b></b>|name<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|arrival date<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|hotel room<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Nights<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|tip<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|breakfast y/n<br><span style="font-weight:normal;color:gray">&lt;logical&gt;</span>|
|:---|:---|:---|:---|---:|---:|:---|
|0|Kamile Sanford|1999-04-21|suite A|5|_\<null>_|true|
|1|Kody Tucker|1999-03-01|suite B|4|_\<null>_|true|
|2|Mandy Hewitt|1999-10-29|suite B|5|_\<null>_|true|
|3|Payton Sellers|1999-11-14|suite B|5|11.07|false|
|4|Jarrad Chang|1999-05-07|suite B|4|8.47|true|
|5|Hakeem Whitley|1999-10-27|suite C|2|_\<null>_|true|
|6|Fred Pruitt|1999-03-26|suite B|5|10.55|false|
|7|Mina Guevara|1999-09-13|suite C|3|_\<null>_|true|
|8|Flynn Oakley|1999-10-26|suite C|3|10.78|true|
|9|Hector Stuart|1999-10-07|suite A|1|11.87|true|

We want to combine all guests that stayed 4 or fewer nights into the 'Other' group. That is possible with the following configuration. 

![](images/group-to-other-settings.png)

With 'Threshold' you set the upper bound for the values that are grouped. 'Group name' is the name of this group. These settings result in the following table.

|<b></b>|name<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|arrival date<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|hotel room<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Nights<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|tip<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|breakfast y/n<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|
|:---|:---|:---|:---|---:|---:|:---|
|0|Kamile Sanford|1999-04-21|suite A|5|_\<null>_|true|
|1|Mandy Hewitt|1999-10-29|suite B|5|_\<null>_|true|
|2|Payton Sellers|1999-11-14|suite B|5|11.07|false|
|3|Fred Pruitt|1999-03-26|suite B|5|10.55|false|
|4|Other|Other|Other|17|31.12|Other|

The transformation sums the values of the other group. It does not support other aggregations.

### See Also

[Add (Sub)Totals](TransformationAddTotal.md), [Group By](TransformationGroupBy.md)

_
