## Transformation: Copy a Column

With this transformation, you can copy an existing column in the table. You cannot copy properties. 

If, for example, we have the following table.

|&nbsp;|Continent<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|#Articles<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|---:|---:|
|0|<span style='color:#00d4ea'>&#9646;</span> Africa|4|€833,200|
|1|<span style='color:#00d4ea'>&#9646;</span> Asia|5|€391,200|
|2|<span style='color:#00d4ea'>&#9646;</span> Europe|5|€5,240,550|
|3|<span style='color:#00d4ea'>&#9646;</span> North America|5|€2,030,300|
|4|<span style='color:#00d4ea'>&#9646;</span> Oceania|4|€363,600|
|5|<span style='color:#00d4ea'>&#9646;</span> South America|5|€156,000|

If we set _Column_ to `Continent` and _Name_ to `test`, then we get the following result. 

|&nbsp;|Continent<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|#Articles<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|test<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|
|:---|:---|---:|---:|:---|
|0|<span style='color:#00d4ea'>&#9646;</span> Africa|4|€833,200|<span style='color:#00d4ea'>&#9646;</span> Africa|
|1|<span style='color:#00d4ea'>&#9646;</span> Asia|5|€391,200|<span style='color:#00d4ea'>&#9646;</span> Asia|
|2|<span style='color:#00d4ea'>&#9646;</span> Europe|5|€5,240,550|<span style='color:#00d4ea'>&#9646;</span> Europe|
|3|<span style='color:#00d4ea'>&#9646;</span> North America|5|€2,030,300|<span style='color:#00d4ea'>&#9646;</span> North America|
|4|<span style='color:#00d4ea'>&#9646;</span> Oceania|4|€363,600|<span style='color:#00d4ea'>&#9646;</span> Oceania|
|5|<span style='color:#00d4ea'>&#9646;</span> South America|5|€156,000|<span style='color:#00d4ea'>&#9646;</span> South America|

As you can see, the _Copy a Column_ transformation also copies the properties of the column. In this example, we see that column `test` has the same colors as `Continent`.



### See Also

[Add a Column](TransformationAddColumn.md),
[Add Property](TransformationAddProperty.md),
[Delete a Column](TransformationDeleteColumn.md)

_