## Transformations: Numeric Color

Use this transformation to generate colors based on the numeric values of a column. It works as follows:

**For _Palette Type_ Palette**

1. Transform the values based on the scale expression. The default is to normalize so that values fall between 0 and 1.
   Read more about numeric scale functions [here](../TidyTableScaleRowExpression.md).
2. Color the values. Values smaller or equal to 0 get the first color of the palette, values between 0 and 1 are
   interpolated, and values equal or greater than 1 get the last color in the palette.

**For _Palette Type_ Color**

1. Transform the values based on the scale expression. The default is to normalize so that values fall between 0.25 and
   0.75. Read more about numeric scale functions [here](../TidyTableScaleRowExpression.md).
2. Lighten or darken the color. Values of 0 are white, 0.5 get the color set in _Color_, and 1 is black. It interpolates
   the color of values between 0 and 1.

### Example

Say we have the following table.

|&nbsp;|Article<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Category<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|#Sales<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|
|0|Personal|License|593|
|1|Server|License|1024|
|2|Silver|Support|372|
|3|Gold|Support|184|
|4|Platinum|Support|88|

We set _Columns_ to `#Sales` and _Palette Type_ to `Color`. We use the default _Lightness Factor_. This results in the
following table.

|&nbsp;|Article<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Category<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|#Sales<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|
|0|Personal|License|<span style='color:rgb(0, 204, 225)'>&#9646;</span> 593|
|1|Server|License|<span style='color:rgb(0, 106, 117)'>&#9646;</span> 1024|
|2|Silver|Support|<span style='color:rgb(33, 234, 255)'>&#9646;</span> 372|
|3|Gold|Support|<span style='color:rgb(89, 239, 255)'>&#9646;</span> 184|
|4|Platinum|Support|<span style='color:rgb(117, 242, 255)'>&#9646;</span> 88|

As you can see, `1024` has the darkest color because it is the largest value.

### See Also

[Replace Nulls](TransformationReplaceNull.md),
[Clear Color](TransformationClearColor.md),
[Categorical Color](TransformationColorCategorical.md),
[Copy Column Color to Table](TransformationColorColumnToTable.md),
[Conditional Color JS](TransformationColorConditionalJS.md),
[Conditional Color](TransformationColorConditionalRule.md),
[Ordinal Color](TransformationColorOrdinal.md),
[Single Color](TransformationColorSingle.md),
[Set Missing Colors](TransformationSetMissingColor.md),
[Modify Color](TransformationTransformColor.md)

_