## Transformation: Clear Cell/Header Colors

Use this transformation to remove colors from the cells or headers of one or more columns. 

A column has a color property if it shows a color when hovering over one of the cells in the query result table. For example, we have the following table with both `Article` and `Category` having color properties.

|&nbsp;|Article<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Category<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|
|0|<span style='color:#ff7c43'>&#9646;</span> Personal|<span style='color:#f95d6a'>&#9646;</span> License|€148,250|
|1|<span style='color:#d45087'>&#9646;</span> Server|<span style='color:#f95d6a'>&#9646;</span> License|€7,132,000|
|2|<span style='color:#003f5c'>&#9646;</span> Silver|<span style='color:#a05195'>&#9646;</span> Support|€575,200|
|3|<span style='color:#2f4b7c'>&#9646;</span> Gold|<span style='color:#a05195'>&#9646;</span> Support|€530,600|
|4|<span style='color:#665191'>&#9646;</span> Platinum|<span style='color:#a05195'>&#9646;</span> Support|€628,800|

We can use the transformation to remove the colors. For example, if we set _Columns_ to `Article`, then we get the following result.

|&nbsp;|Article<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Category<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|
|0|Personal|<span style='color:#f95d6a'>&#9646;</span> License|€148,250|
|1|Server|<span style='color:#f95d6a'>&#9646;</span> License|€7,132,000|
|2|Silver|<span style='color:#a05195'>&#9646;</span> Support|€575,200|
|3|Gold|<span style='color:#a05195'>&#9646;</span> Support|€530,600|
|4|Platinum|<span style='color:#a05195'>&#9646;</span> Support|€628,800|

#### Additional options

Use the option _Clear these Color_ to set what colors the transformation should remove. 
- `header`: remove only the header colors;
- `cell`: remove only the cell colors;
- `cell and header`: remove all colors from the column.

### See Also

[Replace Nulls](TransformationReplaceNull.md),
[Categorical Color](TransformationColorCategorical.md),
[Copy Column Color to Table](TransformationColorColumnToTable.md),
[Conditional Color JS](TransformationColorConditionalJS.md),
[Conditional Color](TransformationColorConditionalRule.md),
[Numeric Color](TransformationColorNumeric.md),
[Ordinal Color](TransformationColorOrdinal.md),
[Single Color](TransformationColorSingle.md),
[Set Missing Colors](TransformationSetMissingColor.md),
[Modify Color](TransformationTransformColor.md)

_