## Transformation: Add Property

With this transformation, you add a property to a column. This property can have a custom name, or have one of the
following names.

**Formatted Value**

The formatted value of a cell. For example, a cell with value `5003` has a formatted value equal to `€5,003`.

**Back Color**

When using MDX sources, cells can have a back color defined.

**Fore Color**

When using MDX sources, cells can have a fore color defined.

**Format String**

The format string for the cell value. For example, euros use the format `€#,###.`
and percentages use `#0.00%`.


**Color**

The main color of the cell. This is the color displayed in the result table.

**App Notification Type**

Column defined to fire an application notification. The name of the notification (e.g., print-report).

**App Notification Payload**

Column defined to fire an application notification.

The parameters of the notification (e.g., page size, filename, …) as a JSON or a string.

**Event Name**

Column defined to fire events, the name of the event.

**Event Caption**

Column defined to fire events, the value of the event to show in text.

**Event Value**

Column defined to fire events, the mdx value of the event used in queries.

**Selection Event Value**

This is the event value that is fired when selecting the cell.

**Selection Event Caption**

This is the event caption that is fired when selecting the cell.

**Caption**

For MDX columns, the caption of the column.

**Key**

Column defined as an MDX axis, the key of the column.

**Tooltip**

Show this when hovering over the cell in the table.

#### Expression

We use expressions to create the values for the new column. The following expressions are available.

- Numeric: javascript that returns a number, e.g., `Math.round($value$/1000)*1000`.
- HTML: a markdown template that returns HTML code, e.g., `<span style='color: red'>$value$</span>`.
- Text (javascript): javascript that returns a string, e.g.,
  ``` 
  if ($value$ < 1000000) {
    return '$value.mean$';
  }
  return 'bar';
  ```
- Scale: scale expression that scales the values, e.g.,
  - a predefined scale expression using a `c.` function
  - min/max scaling: `($value$ - $value.min$) / ($value.max$ - $value.min$)`
  - standardization: `($value$ - $value.mean$) / $value.standardDeviation$`

- Text: template that returns text, e.g., `$axis$ - $value$ ($value.percent.formatPercent()$)` returns 'Africa - €833,200 (9.2%)'.

Use `$_currentColumn$` to reference the current column in the expression.



### See Also

[Add Tooltip Property](TransformationAddTooltipProperty.md)
[Add a Column](TransformationAddColumn.md),
[Modify Values](TransformationApplyFunction.md),
[Copy a Column](TransformationCopyColumn.md),
[Delete a Column](TransformationDeleteColumn.md)
_
