## Transformation: Progress Bar Renderer

With this transformation you can render a column in a table or pivot table as a bar:

![Progress bar renderer](images/rend-progress.png)

Check the [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FTable+%26+Pivot+Table%2FTable+Cell+Renderers).

The value of the bar represents the cell value.

This transformation is assuming the values are positive. Should you have some negative values, you can change
the _Scale_ option using the `c.scaleMaxAbsolute()` function and use different colors in the cells.

In _Text_, you can add an expression that shows as text on top of the rendered bar. For example, use `$_currentCell$` to show the
cell-value, or use `$_currentCell$ ($<nameOfPercentageColumn>$)` where `<nameOfPercentageColumn>` is the result of the percentage
of total transformation. Alternatively, you can also use the [Add Tooltip Property](TransformationAddTooltipProperty.md) transformation to show the values of the cell on hover.

The transformation uses the colors in the column to color the bar. If the cell does not have a color, it uses the
default `chartSingleColors` from the theme.

The _Scale_ option allows for changing how to scale the values on the interval `[0, 1]`. The value `0` means that the bar is empty, and `1` means a full bar.

### See Also

[Percentage of Total](TransformationPercentageOfTotal.md),
[Icon Renderer](TransfRendererIconSet.md),
[Link Renderer](TransfRendererCustom.md),
[Rating Renderer](TransfRendererRating.md),
[Rich Text Renderer](TransfRendererRichText.md),
[Spark Line Renderer](TransfRendererSparkline.md),
[HTML Renderer](TransfRendererHtml.md)

_