Column numeric expressions are [Javascript expressions](TidyTableJSExpr.md)  that can access the widget underlying data
thanks to the data
accessors. A data accessor is basically the name of a column of the query result table enclosed in `$$`.

The expression is evaluated for each of the selected columns setting the `_currentColumn` and returns a javascript
string.

### Examples

You can add a single line with or without quotes to return "#,###."

```
#,###.
```

same as

```
"#,###."
```

Or a javascript expression, in our example returns the format string only for the 'Amount' column

```
if( "$_currentColumn.caption$" !== "Amount" )
   return "#,###."
```

### Data Accessors

Within the expression, tidy table data is available via [Data Accessors](TidyTableDataAccessor.md).

Data accessors of numeric column expressions define a **current column**.

### Completion

Note that code completion is available within a data accessor `$` using `CTRL-SPACE`.

### Null / Undefined

If a default value exists on the expression, and you want to remove it, insert a single space character.