Column numeric expressions are [Javascript expressions](TidyTableJSExpr.md) that can access the widget underlying data
thanks to the data
accessors. A data accessor is basically the name of a column of the query result table enclosed in `$$`.

The expression is evaluated for each of the selected columns setting the `_currentColumn` and returns a javascript
object.

### Examples

Or a javascript expression, in our example returns a string for the column "Year" and a numeric, the columns total, for
the other columns.

```
if( "$_currentColumn.caption$" !== "Year" )
   return "Total";
return $_currentColumn.total$
   
```

### Data Accessors

Within the expression, tidy table data is available via [Data Accessors](TidyTableDataAccessor.md).

Data accessors of numeric column expressions define a **current column**.

### Completion

Note that code completion is available within a data accessor `$` using `CTRL-SPACE`.

### Null / Undefined

If a default value exists on the expression, and you want to remove it, insert a single space character.