Column numeric expressions are [Javascript expressions](TidyTableJSExpr.md)  that can access the widget underlying data
thanks to the data
accessors. A data accessor is basically the name of a column of the query result table enclosed in `$$`.

The expression is evaluated for each of the selected columns setting the `_currentColumn`.

#### Examples

The following is returning `1, -1, 0` according to the actual value of the current column:

```
$_currentColumn$ > 0 ? 1 : $_currentColumn$< 0 ? -1 : 0
```

The next example shows how to perform division with two columns.

```
if (Number($#Customers$) != 0)
    return $Amount$ / $#Customers$;
return null;
```

To prevent `NaN` values due to division by zero, the statement first checks if the value evaluates to zero.
The values `null`, `undefined`, `false`, and `0` evaluate to zero.

### Data Accessors

Within the expression, tidy table data is available via [Data Accessors](TidyTableDataAccessor.md).

Data accessors of numeric column expressions define a **current column**.

### Completion

Note that code completion is available within a data accessor `$` using `CTRL-SPACE`.

### Null / Undefined

If a default value exists on the expression and you want to remove it, insert a single space character.