## Javascript expression

Javascript expressions allow to write javascript code that is going to be evaluated on a given context (table, column,
cell...).

Like :

```
if (Number($#Customers$) != 0)
    return $Amount$ / $#Customers$;
return null;
```
or
```
if ('$Country$' == 'Switzerland')
    return 'Local';
return '$Country$';
```

#### Utility Functions

When evaluating the expression, the utility class `util` is available with a set of functions :

- `getCurrentColumnValue(rowIdx: number)` : The value of the current/default column at position idx (0-based)

- `getColumnValue(column: string | number, rowIdx: number)` : The value of the column at position idx (0-based). If
  column is a number the position in the table, -1 for the last column, 0 for the first column.

- `colorLightness(color: string, coefficient: number)` : Lightens the color if the coefficient < 0.5. Darkens the
  color if the coefficient > 0.5.

- `colorInterpolate(colors: string[], distance: number)` : Interpolates the input array of colors. A distance of 0
  will return the first color and a distance of 1 the last color of the array.

For example, interpolating a color between `red` and `yellow` using 0.2 as distance, will return a color near the red
color :

```
util.colorInterpolate( ['red', 'yellow'], 0.2 )
```

#### Debugging

Debugging is an essential process that helps identify, isolate, and resolve issues and errors in your code. When working
with JavaScript expressions, you have several ways to debug:

1- **Output as Tidy Table Cell Value**

The first and easiest method is to use the same expression as a cell value. This way, the tidy table will display the
value returned by the expression.

2- **Log the Result in the Browser's Console**

You can use `console.log("My Expression: " + value)` and check the browser's console in your developer tools (you can
open it with right-click + inspect).

3- **Use the `debugger` Statement**

Lastly, for more powerful debugging, you can add the `debugger` statement to your expression.
When the browser's developer tool is open, it will automatically stop at this line. You can then use the browser's
debugger.

_
