
## Data Accessors

Some fields defined in chart options and transformations are defined as expressions. A part of this expression
can be a data accessor that is based on the underlying tidy table defined by the widget.

As an example, showing the total in the center of a Pie chart :

```
The Total is $value.total.format$
```

That will be evaluated to :

```
The Total is 50'234
```

Data accessors start and end with a `$` character. You can add multiple data accessors in a same expression.
Completion is available, press CTRL+SPACE after the `$` or `.` to get all available accessors.

There are two main families of expressions, Javascript and text expressions. Javascript expressions will
execute the Javascript statement after replacing the data accessors. Text expressions will replace the data
accessors without any further operation.

### Expression Context

Expressions are defined within a context, the expression context. Most expressions will be defined at cell level.
This means that when evaluating the expression, a tidy table, a column of the tidy table and a row index of the
column are available. All this defines a unique cell within the tidy table.

Some expressions do not have a row index and are evaluated at the table level. For example, the expression that
defines the center text for the Pie chart.

We can also access the selected columns or rows when available. For example, in our Pie chart we can show the total
of the selected value(s).

### Syntax

The full syntax of data accessors is as following :

```
$value.modifier.format()$
```

- [`value`](#value) is mandatory and defines the scope where the values are picked (e.g., column, whole table)
- [`modifier`](#modifier) is optional and defines an optional operator for the picked values (e.g., sum, average)
- [`format()`](#format) is optional and allows for formatting the resulting value

#### Value

Below the list of available value accessors.

```
value                 : the value, if a row index is defined
column name           : an existing column or an alias name
_table                : the underlying tidy table
_selectedColumns      : the selected columns, if any
_currentColumn        : the current column
_currentCell          : the cell value and formatted value, if a row index is defined
_currentRow           : the current row, if a row index is defined
_rowOfSelectedColumns : the rows of the selected columns, if a row index is defined
```

The `value` allows for defining a scope from where we pick the values. It can be the whole tidy table,
a column, the list of columns as well as a single cell. A cell is defined by a column and a row index.

The `column Name` is the name of a column within the query result table, or the name of the data mapping used to select the column
(e.g., value in the column chart). Use the completion to get all the available names. Use `_currentColumn` as
column name to reference the current column available in the evaluation context of that expression. For example,
if the current column is `Sales` then the expressions `$_currentColumn$`, `$_currentColumn.min$` are equivalent
to `$Sales$`,`$Sales.min$`. For example:

```
$Sales.min$       : returns the minimum of the Sales column
```

For a `value`, you can also access: `@ Operator`, `Column Cell` and `Table Cell`. See examples below.

`@ Operator`

Retrieves properties of the column using the `@` operator. For example:

```
$Sales@color$    : returns the color property of the Sales column (e.g.,. #A3F123)
```

or

```
$_currentRow@Count.sum$    : returns the sum of the table columns with properties 'Count' for the currentRow (e.g.,. 42)
```

`Column Cell : column(r)`

Retrieves the value of the row `r` of the column using a function call notation. The index is **0 based**. For example:

```
$Sales(2)$       : returns the value of the third row (row-index:2) of the Sales column
$Sales(-1)$      : returns the value of the last row (row-index:-1) of the Sales column
```

`Table Excluded : _tableExclude( [c],[r] )`

Returns a table excluding all columns `c` and rows `r` using a function call notation. You can use an empty array for
not filtering rows or columns. The indices are **0 based**. For example:

```
$_tableExclude([0],[]).max$     : returns the max value of the table excluding the first column
$_tableExclude([],[-1]).min$    : returns the max value of the table excluding the last row
$_tableExclude([],[0,-1]).min$  : returns the max value of the table excluding the first and the last row
```

`Table Cell : _table(c,r)`

Retrieve the value of the row `r` of the column `c` using a function call notation. The indices are **0 based**. For example:

```
$_table(1,2)$    : returns the value of the third row (row-index:2) of the second column (col-index:1) of the table
$_table(-1,2)$   : returns the value of the last row (row-index:-1) of the second column (col-index:1) of the table
```

`Table Relative Cell : _tableRelative(deltaC,deltaR)`

Retrieve the value of the row `currentRow+deltaR` of the column `currentColumn+deltaC` using a function call notation.
The indices are **0 based**. For example:

```
$_tableRelative(0,0)$   : returns the value of the current cell value
$_tableRelative(1,0)$   : returns the value of following column at the same rowIdx than the current cell
$_tableRelative(0,-1)$  : returns the value of the cell at rowIdx equal to 'currentRowIdx-1', null if currentRowIdx is equal to zero
```

The function _tableRelative will return null if the context does not define a cell and if the cell requested is outside
the bounds of the table.

#### Modifier

Once we define the data context with the `value`, the optional `modifier` allows for applying an operations
to the value.

**With a row index being defined**, the available operations are :

```
current          : the current value
columnIndex      : column index in the table (starts 0)
index (rowIndex) : column row index (starts 0)
caption          : column caption (localized)
getName          : column name (not localized)
getCaption       : same as caption
getValue         : cell value, same as current
getUid           : table uid
groupColumnIndex : column index in the column group (available if the chart defines a group role)
groupValue       : the total value of the current group (available if the chart defines a group role)
hasChildren      : true if the cell defines an MDX member with children
mdxName          : the MDX name if the cell defines an MDX members
mdxCaption       : the MDX caption if the cell defines an MDX members
mdxUniqueName    : the MDX unique name if the cell defines an MDX members
mdxKey           : the MDX key if the cell defines an MDX members
prev             : the value of the previous row index, undefined if the current cell is the first one
next             : the value of the next row index, undefined if the current cell is the last one
first            : the first value of the current column
last             : the last value of the current column
percent          : the percent of the current value w.r.t. the total of the column
percentFirst     : the percentage of the current value w.r.t. the first value of the column
percentLast      : the percentage of the current value w.r.t. the last value of the column
percentGroup     : the percentage of the current value w.r.t. the group value (available if the chart defines a group role)
percentTable     : the percentage of the current value w.r.t. the total of the table
percentRow       : the percentage of the current value w.r.t. the total of the current row
scaleMaxAbsolute : normalizes the current value so that the column values are on [-1, 1]
scaleStandardize : normalizes the current value so that the column values are on [0, 1]
```

**Without a row index being defined**, the available operations are :

```
count                : the number of cells
min                  : the minimum
max                  : the maximum
total                : the total
sum                  : same as total
totalSelectedOrTotal : the total of the selected cells or the total if no selection
average              : the average
mean                 : same as average
median               : the median
variance             : the variance
standardDeviation    : the standard deviation
```

For example, if `value` is defined as `_table` it will be for all cells of all numeric values.

For example :

```
$column.caption$ : $column.total$
```

will display the total of the column `Amount` :

```
Amount : 42
```

#### Format

The last part `format()` allows for formatting the resulting value. The formatters are :

```
formatDate()    : without any format argument the default date formatter is being used
formatNumber()  : without any format argument the default number formatter is being used
formatAmount()  : without any format argument the default amount formatter is being used
formatPercent() : without any format argument the default percentage formatter is being used
value()         : do not apply any formatting
```

The syntax of the [amCharts 4 formatters](https://www.amcharts.com/docs/v4/concepts/formatters/) is used to define
the optional argument of the `format` function. For example:

```
$value.total.formatNumber("#,###.00")$
```

Note that any additional formatters defined in the theme of your report are available as formatters as well.
Use the completion to get all the available format functions.

To not use any formatting, you can use `$value.value()$`.

**Default formatting**

If a text expressions does not have a format function, then the value is formatted using the MDX `FORMAT_STRING` property. When no `FORMAT_STRING` is available, a default
formatter from the theme is used.

### Escaping

#### Escaping dollars

Should you need to use `$` within your expression, you'll need to escape it by duplicating it. For example,
assuming the column `Count$0$` exists and its total equals to `42`, the following expression :

```
$$0$$: $Count$$0$$$
``` 

is rendered as :

```
$0$: 42
```

Do not forget to escape `$` within the format argument as well.

> Special case: 
> 
> If your column name starts with a `$` character, then you can escape it with `_ic3_dollars__`. For example, if your column name is `$Diff`, then you should use `$_ic3_dollars__Diff$`.

#### Escaping dot

Should you need to use the dot `.` within a column name you'll need to escape it by duplicating it. Note that
white space are allowed within a column name. For example, assuming the column `Amount Ex.` exists and
its total equals to `42`, the following expression :

```
$Amount Ex...total$
``` 

is rendered as :

```
42
```

### Javascript expression

When in a Javascript expression, using `$selector.modifier$ ?? val` evaluates to `val` when the result of the data accessor
is null.

### Examples

Say, we evaluate the following table :

| Country<br>`character` | Year <br>`numeric` | Population <br>`numeric` | Increase <br>`numeric` | is 20th c.<br>`logical` | 
|:-----------------------|:-------------------|-------------------------:|-----------------------:|------------------------:| 
| France                 | 2020               |               65,273,511 |                  +3.2% |                   false | 
| France                 | 2010               |                     null |                  +6.7% |                   false | 
| France                 | 2000               |               59,015,096 |                  +5.4% |                    true |

for the row 2 and column `Increase`, then the following statements evaluate to :

```
$Year$                            :  2010
$Year(0)$                         :  2020
$Year.sum$                        :  6030
$Year.sum.formatNumber("#,###")$  :  6'030
$Country$                         :  France
$_currentCell$                    :  0.067
$_currentCell.formatNumber()$     :  +6.7%
$_currentColumn.total$            :  0.153
$is 20th c..$                     :  false
$is 20th c...total$               :  1
$_table(1,0)$                     :  2020
$Population$ ?? 0                 :  0 (only for Javascript expressions)
```

_
