A color expression is a [Javascript expressions](TidyTableJSExpr.md) that returns a color. The transformation evaluates
this function for each
cell in the selected column(s).

### Examples

This example returns yellow if the cell value is greater than 2 and the fourth color of the default palette otherwise:

```js
if ($_currentCell$ > 2) { // cell value of current column
    return '#ffff00';  // return yellow hex
}
return 'default.3';  // theme palette 'default' fourth color
```

### Theme Colors

You can select a color from the theme by returning the name of that color. If a color is a palette, you can append `.n`
to the string to get the _n_-th position (replace `n` by a number). For example, returning `'default'` gives the default
single color from the theme and returning `'default.3'` gives the fourth color of the default palette.

### Data Accessors

Within the expression, tidy table data is available via [Data Accessors](TidyTableDataAccessor.md).

Data accessors of color expressions define a **row index**.

### Completion

Note that code completion is available within a data accessor `$$` using `CTRL-SPACE`.

### Null / Undefined

If a default value exists on the expression and you want to remove it, insert a single space character.