## Tidy Table

Once executed, a widget query response is transformed into a tidy table to feed the widget
(e.g., table, chart, maps, filters, etc.).

The tidy table gets its name from the way the table stores the data. Each column of the table corresponds to a variable
and each row to an observation. In data-science, we call such a table _tidy_, hence the name. See the table below for an
example of data that is tidy.

|&nbsp;|Country<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Year<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Population<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Increase<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Is 20th century<br><span style="font-weight:normal;color:gray">&lt;logical&gt;</span>|
|:---|:---|---:|---:|---:|:---|
|0|France|2020|65273511|3.2|false|
|1|France|2010|62879530|6.7|false|
|2|France|2000|59015096|5.4|true|
|3|France|1990|56666849|5.2|true|
|4|France|1980|53868009|_\<null>_|true|

In the table above, each observation is a country in a certain year. The columns `Population`, `Increase` and
`Is 20th century` are the variables. What's important, is that all the values in the column have the same type. A value
can also be missing, then the value equals _\<null\>_.

#### Column Types

The following column types are available

* `color` - color data
* `longitude` - the longitude of a coordinate
* `latitude` - the latitude of a coordinate
* `datetime` - timestamps
* `numeric` - numeric values
* `character` - textual values / strings
* `logical` - true or false
* `list` - the value is an array, e.g., \['a', 'b', 'c'\]
* `mixed` - the column has more than one datatype
* `unknown` - unknown type
* `null` - all values are _\<null\>_
* `any` - use any to opt-out of type checking
* `iso2Location` - ISO2 location code, e.g., country, region or city code

#### Properties

A column in a tidy table can have several properties. A property describes extra information for each cell in that
column. Several property names are reserved and have special meaning, see the list below.

* color - the color of the cell.
* tooltip - the tooltip of the cell. The cell displays this tooltip when the user hovers over it.
* formattedValue - the formatted value of the cell value. For example, 23985 can be formatted as €23,985-.

For more details, see the documentation about a query defined as a CSV (table definition) both for a
[chart](../query/TableDefinitionQuery.md) and a [filter](../query/FilterTableDefinitionQuery.md).

#### Widget Rendering

At the start of the widget rendering is the query. This can either be an MDX query or an embedded source. This query
results in a tidy table. Then, the transformations defined in the tab 'TRANSFORMATION' are applied to the tidy table.
The widget uses the resulting table in its rendering. Properties on the column, such as color or formatted value, are
used as additional information in rendering the widget.

#### Creating a Tidy Table from MDX Queries

The conversion from a multidimensional MDX query to a flat tidy table works as follows:

1. The members in the 'ON 0' axis become the columns in the table. If this axis contains tuples, then it converts the
   tuples to a single column.
2. The remaining axes are the other columns in the table. The order is the same as axis order in the query. These
   columns take the cross-join of the axes as values, expanding in the row-direction.

For example, the query:

```
SELECT 
{ [Measures].[Amount], [Measures].[#Licences] } ON 0
{ [Geography].[Geography].[City].[Brussels],
  [Geography].[Geography].[City].[Amsterdam],
  [Geography].[Geography].[City].[Geneva] } ON 1
{ [Time].[Year].[2018], [Time].[Year].[2019] } ON 2
FROM [Sales]
```

produces:

|&nbsp;|City<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Year<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|#Licences<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|---:|---:|
|0|Brussels|2018|_\<null>_|_\<null>_|
|1|Brussels|2019|€18,300|21|
|2|Amsterdam|2018|_\<null>_|_\<null>_|
|3|Amsterdam|2019|_\<null>_|_\<null>_|
|4|Geneva|2018|€123,000|144|
|5|Geneva|2019|€2,600|8|

As a best practice, we recommend to always set the measures in your query on the 'ON 0' axis. This way, you are
guaranteed to have the table in tidy format.

_
